/*
 *
 *  Copyright (C) 2021 Andrew Gegg
 *
 * 	This file is part of the Gardeners Notebook application
 *
 *  The Gardeners Notebook application is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 *
 *
 */

package uk.co.gardennotebook.mysql;

import uk.co.gardennotebook.spi.INotebookEntry;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.beans.PropertyChangeSupport;
import java.util.function.BiConsumer;

/**
 *Handles the various flags used to signal changes to underlying entries
 *
 *	@author	Andy Gegg
 *	@version	3.0.0
 *	@since	3.0.0
 */

final class FlagHandler<T extends INotebookEntry>
{
    private final T caller;

    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    FlagHandler(T caller)
    {
        this.caller = caller;
    }

    public void addPropertyChangeListener(final String propertyName, final PropertyChangeListener listener)
    {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(final String propertyName, final PropertyChangeListener listener)
    {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public void flagDeleted()
    {
        this.pcs.firePropertyChange("deleted", caller, null);
        PropertyChangeListener[] pcls = pcs.getPropertyChangeListeners();
        for (PropertyChangeListener pcl : pcls)
        {
            pcs.removePropertyChangeListener(pcl);
        }
    }

    public void flagReplaced(T newValue, BiConsumer<String, PropertyChangeListener> flagger)
    {
        PropertyChangeListener[] pcls = pcs.getPropertyChangeListeners();
        for (PropertyChangeListener pcl : pcls)
        {
            if (pcl instanceof PropertyChangeListenerProxy proxy)
            {
                flagger.accept(proxy.getPropertyName(), proxy.getListener());
//                newValue.addPropertyChangeListener(proxy.getPropertyName(), proxy.getListener());
            }
        }
        this.pcs.firePropertyChange("replaced", caller, newValue);
        for (PropertyChangeListener pcl : pcls)
        {
            pcs.removePropertyChangeListener(pcl);
        }

    }

    public void flagChildDeleted(String propertyName, INotebookEntry child)
    {
        this.pcs.firePropertyChange(propertyName, child, null);
    }

    public void flagChildAdded(String propertyName, INotebookEntry child)
    {
        this.pcs.firePropertyChange(propertyName, null, child);
    }


}
