/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	Do not edit this file, it is generated.
 */

package uk.co.gardennotebook.spi;

import java.beans.PropertyChangeListener;
import java.util.List;
import java.time.*;

import java.util.Optional;

/**
*	The types of weather observed as noteworthy.  For daily observations, use the Weather Details table.
*
*	@author	Andy Gegg
*	@version	1.0
*	@since	1.0
*/
public interface IWeatherCondition extends INotebookEntry
{
	/**
	*	Get the value of name.
	*
	*	@return	the value of name
	*/
	public String getName();

	/**
	*	Get the value of description (if present).
	*
	*	@return	the value of description
	*/
	public Optional<String> getDescription();

	/**
	*	Get the value of lastUpdated.
	*
	*	@return	the value of lastUpdated
	*/
	public LocalDateTime getLastUpdated();

	/**
	*	Get the value of created.
	*
	*	@return	the value of created
	*/
	public LocalDateTime getCreated();


	/**
	*	Get the Weather entries for this WeatherCondition.
	*
	*	@return	 a lister for the Weather entries
	*/
	public IWeatherLister getWeather();

	/**
	*	Add a change listener to the WeatherCondition.
	*
	*	@param	propertyName	identifies the change being flagged.  One of:<UL>
	*			<LI>deleted	-	this object has been deleted from the database, oldValue is the deleted object
	*			<LI>replaced	-	this object has been replaced in the database, oldValue is the deleted object, newValue its replacement
	*			<LI>Comment	-	this comment has been added to or deleted from this WeatherCondition, newValue is an added comment, oldValue is a deleted comment
	*			<LI>Weather	-	this Weather has been added to or deleted from this WeatherCondition's children, newValue is an added object, oldValue is the deleted object
	</UL>
	*	@param	listener	a PropertyChangeListener (may be a Lambda expression)
	*/
	public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener);

	/**
	*	Remove a change listener from the WeatherCondition.
	*
	*	@param	propertyName	identifies the change being flagged.  One of:<UL>
	*			<LI>deleted	-	this object has been deleted from the database, oldValue is the deleted object
	*			<LI>replaced	-	this object has been replaced in the database, oldValue is the deleted object, newValue its replacement
	*			<LI>Comment	-	this comment has been added to or deleted from this WeatherCondition, newValue is an added comment, oldValue is a deleted comment
	*			<LI>Weather	-	this Weather has been added to or deleted from this WeatherCondition's children, newValue is an added object, oldValue is the deleted object
	</UL>
	*	@param	listener	the listener to remove
	*/
	public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener);

	/**
	*	Signal to all listeners that this WeatherCondition has been deleted.
	*
	*/
	public void flagDeleted();

	/**
	*	Signal to all listeners that this WeatherCondition has been replaced.
	*
	*	@param	newValue	the replacement WeatherCondition
	*/
	public void flagReplaced(IWeatherCondition newValue);

	/**
	*	Signal to all listeners that a child has been deleted.
	*
	*	@param	child	this Weather is no longer a child of this WeatherCondition
	*/
	public void flagChildDeleted(IWeather child);

	/**
	*	Signal to all listeners that a child has been added.
	*
	*	@param	child	this Weather has been added as a child of this WeatherCondition
	*/
	public void flagChildAdded(IWeather child);

}

