/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	Do not edit this file, it is generated.
 */

package uk.co.gardennotebook.spi;

import java.beans.PropertyChangeListener;
import java.util.List;
import java.time.*;

import java.util.Optional;

/**
*	A noteworthy weather event.
*
*	@author	Andy Gegg
*	@version	1.0
*	@since	1.0
*/
public interface IWeather extends INotebookEntry
{
	/**
	*	The owning WeatherCondition.
	*
	*	@return	the WeatherCondition
	*/
	public IWeatherCondition getWeatherCondition();

	/**
	*	Get the value of date.
	*
	*	@return	the value of date
	*/
	public LocalDate getDate();

	/**
	*	Get the value of severity (if present).
	*
	*	@return	the value of severity
	*/
	public Optional<String> getSeverity();

	/**
	*	Get the value of lastUpdated.
	*
	*	@return	the value of lastUpdated
	*/
	public LocalDateTime getLastUpdated();

	/**
	*	Get the value of created.
	*
	*	@return	the value of created
	*/
	public LocalDateTime getCreated();


	/**
	*	Add a change listener to the Weather.
	*
	*	@param	propertyName	identifies the change being flagged.  One of:<UL>
	*			<LI>deleted	-	this object has been deleted from the database, oldValue is the deleted object
	*			<LI>replaced	-	this object has been replaced in the database, oldValue is the deleted object, newValue its replacement
	*			<LI>Comment	-	this comment has been added to or deleted from this Weather, newValue is an added comment, oldValue is a deleted comment
	</UL>
	*	@param	listener	a PropertyChangeListener (may be a Lambda expression)
	*/
	public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener);

	/**
	*	Remove a change listener from the Weather.
	*
	*	@param	propertyName	identifies the change being flagged.  One of:<UL>
	*			<LI>deleted	-	this object has been deleted from the database, oldValue is the deleted object
	*			<LI>replaced	-	this object has been replaced in the database, oldValue is the deleted object, newValue its replacement
	*			<LI>Comment	-	this comment has been added to or deleted from this Weather, newValue is an added comment, oldValue is a deleted comment
	</UL>
	*	@param	listener	the listener to remove
	*/
	public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener);

	/**
	*	Signal to all listeners that this Weather has been deleted.
	*
	*/
	public void flagDeleted();

	/**
	*	Signal to all listeners that this Weather has been replaced.
	*
	*	@param	newValue	the replacement Weather
	*/
	public void flagReplaced(IWeather newValue);

}

