/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	Do not edit this file, it is generated.
 */

package uk.co.gardennotebook.spi;

import uk.co.gardennotebook.util.SimpleMoney;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.time.*;

import java.math.BigDecimal;

import java.util.Optional;

/**
*	A sale of produce.
*
*	@author	Andy Gegg
*	@version	1.0
*	@since	1.0
*/
public interface ISale extends INotebookEntry
{
	/**
	*	Get the value of date.
	*
	*	@return	the value of date
	*/
	public LocalDate getDate();

	/**
	*	Get the value of purchasedBy (if present).
	*
	*	@return	the value of purchasedBy
	*/
	public Optional<String> getPurchasedBy();

	/**
	*	Get the value of totalCost (if present).
	*
	*	@return	the value of totalCost
	*/
	public Optional<BigDecimal> getTotalCost();

	/**
	*	Get the value of currency (if present).
	*
	*	@return	the value of currency
	*/
	public Optional<String> getCurrency();

	/**
	*	Get the value of lastUpdated.
	*
	*	@return	the value of lastUpdated
	*/
	public LocalDateTime getLastUpdated();

	/**
	*	Get the value of created.
	*
	*	@return	the value of created
	*/
	public LocalDateTime getCreated();

	/**
	*	Get the value of totalCost as a Money value.
	*
	*	@return	the value of totalCost
	*/
	public SimpleMoney getTotalPrice();


	/**
	*	Get the SaleItem entries for this Sale.
	*
	*	@return	 a lister for the SaleItem entries
	*/
	public ISaleItemLister getSaleItem();

	/**
	*	Add a change listener to the Sale.
	*
	*	@param	propertyName	identifies the change being flagged.  One of:<UL>
	*			<LI>deleted	-	this object has been deleted from the database, oldValue is the deleted object
	*			<LI>replaced	-	this object has been replaced in the database, oldValue is the deleted object, newValue its replacement
	*			<LI>Comment	-	this comment has been added to or deleted from this Sale, newValue is an added comment, oldValue is a deleted comment
	*			<LI>SaleItem	-	this SaleItem has been added to or deleted from this Sale's children, newValue is an added object, oldValue is the deleted object
	</UL>
	*	@param	listener	a PropertyChangeListener (may be a Lambda expression)
	*/
	public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener);

	/**
	*	Remove a change listener from the Sale.
	*
	*	@param	propertyName	identifies the change being flagged.  One of:<UL>
	*			<LI>deleted	-	this object has been deleted from the database, oldValue is the deleted object
	*			<LI>replaced	-	this object has been replaced in the database, oldValue is the deleted object, newValue its replacement
	*			<LI>Comment	-	this comment has been added to or deleted from this Sale, newValue is an added comment, oldValue is a deleted comment
	*			<LI>SaleItem	-	this SaleItem has been added to or deleted from this Sale's children, newValue is an added object, oldValue is the deleted object
	</UL>
	*	@param	listener	the listener to remove
	*/
	public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener);

	/**
	*	Signal to all listeners that this Sale has been deleted.
	*
	*/
	public void flagDeleted();

	/**
	*	Signal to all listeners that this Sale has been replaced.
	*
	*	@param	newValue	the replacement Sale
	*/
	public void flagReplaced(ISale newValue);

	/**
	*	Signal to all listeners that a child has been deleted.
	*
	*	@param	child	this SaleItem is no longer a child of this Sale
	*/
	public void flagChildDeleted(ISaleItem child);

	/**
	*	Signal to all listeners that a child has been added.
	*
	*	@param	child	this SaleItem has been added as a child of this Sale
	*/
	public void flagChildAdded(ISaleItem child);

}

