/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	Do not edit this file, it is generated.
 */

package uk.co.gardennotebook.spi;

import java.beans.PropertyChangeListener;
import java.util.List;
import java.time.*;

import java.util.Optional;

/**
*	Anywhere that items are purchased, includes garden centres, supermarkets, online shopping, etc, etc.<BR>(A more obvious name would be Supplier but that causes a potential name clash in Java)
*
*	@author	Andy Gegg
*	@version	1.0
*	@since	1.0
*/
public interface IRetailer extends INotebookEntry
{
	/**
	*	Get the value of name.
	*
	*	@return	the value of name
	*/
	public String getName();

	/**
	*	Get the value of description (if present).
	*
	*	@return	the value of description
	*/
	public Optional<String> getDescription();

	/**
	*	Get the value of address (if present).
	*
	*	@return	the value of address
	*/
	public Optional<String> getAddress();

	/**
	*	Get the value of webSite (if present).
	*
	*	@return	the value of webSite
	*/
	public Optional<String> getWebSite();

	/**
	*	Get the value of eMail (if present).
	*
	*	@return	the value of eMail
	*/
	public Optional<String> getEMail();

	/**
	*	Get the value of phone (if present).
	*
	*	@return	the value of phone
	*/
	public Optional<String> getPhone();

	/**
	*	Get the value of mobile (if present).
	*
	*	@return	the value of mobile
	*/
	public Optional<String> getMobile();

	/**
	*	Get the value of ownBrandOnly.
	*
	*	@return	the value of ownBrandOnly
	*/
	public boolean isOwnBrandOnly();

	/**
	*	Get the value of lastUpdated.
	*
	*	@return	the value of lastUpdated
	*/
	public LocalDateTime getLastUpdated();

	/**
	*	Get the value of created.
	*
	*	@return	the value of created
	*/
	public LocalDateTime getCreated();


	/**
	*	Get the ProductBrand entries for this Retailer.
	*
	*	@return	 a lister for the ProductBrand entries
	*/
	public IProductBrandLister getProductBrand();

	/**
	*	Get the Purchase entries for this Retailer.
	*
	*	@return	 a lister for the Purchase entries
	*/
	public IPurchaseLister getPurchase();

	/**
	*	Get the RetailerHasProduct entries for this Retailer.
	*
	*	@return	 a lister for the RetailerHasProduct entries
	*/
	public IRetailerHasProductLister getRetailerHasProduct();

	/**
	*	Add a change listener to the Retailer.
	*
	*	@param	propertyName	identifies the change being flagged.  One of:<UL>
	*			<LI>deleted	-	this object has been deleted from the database, oldValue is the deleted object
	*			<LI>replaced	-	this object has been replaced in the database, oldValue is the deleted object, newValue its replacement
	*			<LI>Comment	-	this comment has been added to or deleted from this Retailer, newValue is an added comment, oldValue is a deleted comment
	*			<LI>ProductBrand	-	this ProductBrand has been added to or deleted from this Retailer's children, newValue is an added object, oldValue is the deleted object
	*			<LI>Purchase	-	this Purchase has been added to or deleted from this Retailer's children, newValue is an added object, oldValue is the deleted object
	*			<LI>RetailerHasProduct	-	this RetailerHasProduct has been added to or deleted from this Retailer's children, newValue is an added object, oldValue is the deleted object
	</UL>
	*	@param	listener	a PropertyChangeListener (may be a Lambda expression)
	*/
	public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener);

	/**
	*	Remove a change listener from the Retailer.
	*
	*	@param	propertyName	identifies the change being flagged.  One of:<UL>
	*			<LI>deleted	-	this object has been deleted from the database, oldValue is the deleted object
	*			<LI>replaced	-	this object has been replaced in the database, oldValue is the deleted object, newValue its replacement
	*			<LI>Comment	-	this comment has been added to or deleted from this Retailer, newValue is an added comment, oldValue is a deleted comment
	*			<LI>ProductBrand	-	this ProductBrand has been added to or deleted from this Retailer's children, newValue is an added object, oldValue is the deleted object
	*			<LI>Purchase	-	this Purchase has been added to or deleted from this Retailer's children, newValue is an added object, oldValue is the deleted object
	*			<LI>RetailerHasProduct	-	this RetailerHasProduct has been added to or deleted from this Retailer's children, newValue is an added object, oldValue is the deleted object
	</UL>
	*	@param	listener	the listener to remove
	*/
	public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener);

	/**
	*	Signal to all listeners that this Retailer has been deleted.
	*
	*/
	public void flagDeleted();

	/**
	*	Signal to all listeners that this Retailer has been replaced.
	*
	*	@param	newValue	the replacement Retailer
	*/
	public void flagReplaced(IRetailer newValue);

	/**
	*	Signal to all listeners that a child has been deleted.
	*
	*	@param	child	this ProductBrand is no longer a child of this Retailer
	*/
	public void flagChildDeleted(IProductBrand child);

	/**
	*	Signal to all listeners that a child has been added.
	*
	*	@param	child	this ProductBrand has been added as a child of this Retailer
	*/
	public void flagChildAdded(IProductBrand child);

	/**
	*	Signal to all listeners that a child has been deleted.
	*
	*	@param	child	this Purchase is no longer a child of this Retailer
	*/
	public void flagChildDeleted(IPurchase child);

	/**
	*	Signal to all listeners that a child has been added.
	*
	*	@param	child	this Purchase has been added as a child of this Retailer
	*/
	public void flagChildAdded(IPurchase child);

	/**
	*	Signal to all listeners that a child has been deleted.
	*
	*	@param	child	this RetailerHasProduct is no longer a child of this Retailer
	*/
	public void flagChildDeleted(IRetailerHasProduct child);

	/**
	*	Signal to all listeners that a child has been added.
	*
	*	@param	child	this RetailerHasProduct has been added as a child of this Retailer
	*/
	public void flagChildAdded(IRetailerHasProduct child);

}

