/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	Do not edit this file, it is generated.
 */

package uk.co.gardennotebook.spi;

import java.util.List;

import java.time.*;

import java.math.BigDecimal;

/**
An item in a Purchase.
*/
public interface IPurchaseItemLister
{
	/**
	*	Returns the PurchaseItem entries matching the given criteria.
	*	If no criteria have been specified all PurchaseItem entries will be returned.
	*	Criteria are applied additively (i.e. criterion AND criterion).
	*
	*	@return	A list of PurchaseItem entries matching previously specified criteria.
	*
	*	@throws	GNDBException	If the underlying persistence store (e.g. a database) throws an exception.
	*			The causal Exception can be retrieved via <code>getCause()</code>
	*/
	public List<IPurchaseItem> fetch() throws GNDBException;

	/**
	*	Select only these PurchaseItem entries
	*	May be called repeatedly to add to the list of PurchaseItem entries to be returned
	*
	*	@param items	the list of PurchaseItem entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IPurchaseItemLister purchaseItem(IPurchaseItem... items);

	/**
	*	Select only these PurchaseItem entries
	*	May be called repeatedly to add to the list of PurchaseItem entries to be returned
	*
	*	@param items	the list of PurchaseItem entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IPurchaseItemLister purchaseItem(List<IPurchaseItem> items);

	/**
	*	Select only those PurchaseItem entries which are for these Product entries.
	*	May be called repeatedly to add to the list of Product entries to be selected.
	*
	*	@param items	the list of Product items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IPurchaseItemLister product(IProduct... items);

	/**
	*	Select only those PurchaseItem entries which are for these Product entries.
	*	May be called repeatedly to add to the list of Product entries to be selected
	*
	*	@param items	the list of Product items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IPurchaseItemLister product(List<IProduct> items);

	/**
	*	Select only those PurchaseItem entries which are for these Purchase entries.
	*	May be called repeatedly to add to the list of Purchase entries to be selected.
	*
	*	@param items	the list of Purchase items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IPurchaseItemLister purchase(IPurchase... items);

	/**
	*	Select only those PurchaseItem entries which are for these Purchase entries.
	*	May be called repeatedly to add to the list of Purchase entries to be selected
	*
	*	@param items	the list of Purchase items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IPurchaseItemLister purchase(List<IPurchase> items);

}
