/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	Do not edit this file, it is generated.
 */

package uk.co.gardennotebook.spi;

import java.util.List;

/**
Categories of purchased products.
*/
public interface IProductCategoryLister
{
	/**
	*
	*	Returns the ProductCategory entries matching the given criteria
	*	If no criteria have been specified all ProductCategory entries will be returned
	*	Criteria are applied additively (i.e. criterion AND criterion)
	*
	*	@return	A list of ProductCategory entries matching previously specified criteria
	*
	*	@throws	GNDBException	If the underlying persistence store (e.g. a database) throws an exception.
	*			The causal Exception can be retrieved via <code>getCause()</code>
	*/
	public List<IProductCategory> fetch() throws GNDBException;

	/**
	*
	*	Select only these ProductCategory entries
	*	May be called repeatedly to add to the list of ProductCategory entries to be returned
	*
	*	@param items	the list of ProductCategory entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IProductCategoryLister key(IProductCategory... items);
	/**
	*
	*	Select only these ProductCategory entries
	*	May be called repeatedly to add to the list of ProductCategory entries to be returned
	*
	*	@param items	the list of ProductCategory entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IProductCategoryLister key(List<IProductCategory> items);

	/**
	*
	*	Select only the ProductCategory entries with these name values
	*	May be called repeatedly to add to the list of name entries to be selected
	*
	*	@param items	the list of name values.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IProductCategoryLister name(String... items);

}
