/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	Do not edit this file, it is generated.
 */

package uk.co.gardennotebook.spi;

import java.util.List;

import java.time.*;

/**
Detailed information about a plant often not required.
*/
public interface IPlantDetailsLister
{
	/**
	*	Returns the PlantDetails entries matching the given criteria
	*	If no criteria have been specified all PlantDetails entries will be returned
	*	Criteria are applied additively (i.e. criterion AND criterion)
	*
	*	@return	A list of PlantDetails entries matching previously specified criteria
	*
	*	@throws	GNDBException	If the underlying persistence store (e.g. a database) throws an exception.
	*			The causal Exception can be retrieved via <code>getCause()</code>
	*/
	public List<IPlantDetails> fetch() throws GNDBException;

	/**
	*	Select only these PlantDetails entries
	*	May be called repeatedly to add to the list of PlantDetails entries to be returned
	*
	*	@param items	the list of PlantDetails entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IPlantDetailsLister plantDetails(IPlantDetails... items);

	/**
	*	Select only these PlantDetails entries
	*	May be called repeatedly to add to the list of PlantDetails entries to be returned
	*
	*	@param items	the list of PlantDetails entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IPlantDetailsLister plantDetails(List<IPlantDetails> items);

	/**
	*	Select only those PlantDetails entries which are for these PlantSpecies entries
	*	May be called repeatedly to add to the list of PlantSpecies entries to be selected
	*	If PlantSpecies and PlantVariety lists are BOTH supplied, PlantDetails entries matching either will be selected
	*
	*	@param items	the list of PlantSpecies items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IPlantDetailsLister plantSpecies(IPlantSpecies... items);

	/**
	*	Select only those PlantDetails entries which are for these PlantSpecies entries
	*	May be called repeatedly to add to the list of PlantSpecies entries to be selected
	*	If PlantSpecies and PlantVariety lists are BOTH supplied, PlantDetails entries matching either will be selected
	*
	*	@param items	the list of PlantSpecies items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IPlantDetailsLister plantSpecies(List<IPlantSpecies> items);

	/**
	*	Select only those PlantDetails entries which are for these PlantVariety entries
	*	May be called repeatedly to add to the list of PlantVariety entries to be selected
	*	If PlantSpecies and PlantVariety lists are BOTH supplied, PlantDetails entries matching either will be selected
	*
	*	@param items	the list of PlantVariety items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IPlantDetailsLister plantVariety(IPlantVariety... items);

	/**
	*	Select only those PlantDetails entries which are for these PlantVariety entries
	*	May be called repeatedly to add to the list of PlantVariety entries to be selected
	*	If PlantSpecies and PlantVariety lists are BOTH supplied, PlantDetails entries matching either will be selected
	*
	*	@param items	the list of PlantVariety items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IPlantDetailsLister plantVariety(List<IPlantVariety> items);

}
