/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	Do not edit this file, it is generated.
 */

package uk.co.gardennotebook.spi;

import java.util.List;

/**
 *	Basic functionality of all items
*
*	@author	Andy Gegg
*	@version	1.0
*	@since	1.0
*/
public interface INotebookEntry
{

	/**
	*	get the primary key for this item
	*
	*	@return	 the primary key
	*/
	public Integer getKey();

	/**
	*	get the type of this item
	*
	*	@return	 the item type
	*/
	public NotebookEntryType getType();

	/**
	*	Check if two items are the same.
	*	This is just a key comparison not a full check on all fields.
	*	There is no expectation that this meets the criteria of equals() or hashValue().
	*
	*	@param	other	the item to be compared to
	*
	*	@return	true if the two objects represent the same item
	*/
	public default boolean sameAs(INotebookEntry other)
	{
		if (other == null || other.getType() != this.getType())
		{
			return false;
		}
		return other.getKey().equals(this.getKey());
	}

	/**
	*	Get the comments on this item.
	*
	*	@return	 the list of comments, possibly an empty list
	*/
	public List<IComment> getComments();

}

