/*
 *
 *  Copyright (C) 2024 Andrew Gegg
 *
 * 	This file is part of the Gardeners Notebook application
 *
 *  The Gardeners Notebook application is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 *
 *
 */

 /*
    Change log
    3.2.1   Support selection by Location
 */

package uk.co.gardennotebook.spi;

import java.time.LocalDate;
import java.util.Optional;

/**
 *	An event in the lifecycle of a crop, to be used in the Analysis package.
 *  The entries include Storyline information.
 *
 *	@author	Andy Gegg
 *	@version	3.2.1
 *	@since	3.2.0
 */
public interface ILifecycleAnalysis
{
    /**
     * The date of the Lifecycle event
     *
     * @return  The date of the Lifecycle event
     */

    LocalDate date();

    /**
     * The initial activity in the Lifecycle.
     * This is usually, but NOT necessarily, a Husbandry
     *
     * @return  the initial activity in the Lifecycle.
     */
    Optional<IHusbandry> ancestorHusbandry();
    Optional<IGroundwork> ancestorGroundwork();
    Optional<IAfflictionEvent> ancestorAfflictionEvent();

    /**
     * The type of the initial activity (HU, AE, GW)
     *
     * @return the type of the child entry (HU, AE, GW)
     */
    NotebookEntryType ancestorType();

    /**
     * The type of the child entry (HU, AE, GW)
     *
     * @return the type of the child entry (HU, AE, GW)
     */
    NotebookEntryType childType();

    /**
     * The Husbandry activity, if this is a Husbandry event.
     *
     * @return  null if this is not a Husbandry event.
     */
    int husbandryId();
    Optional<IHusbandry> husbandry();

    /**
     * The AfflictionEvent, if this is an AfflictionEvent.
     *
     * @return  null if this is not an AfflictionEvent event.
     */
    int afflictionEventId();
    Optional<IAfflictionEvent> afflictionEvent();

    /**
     * The Groundwork activity, if this is a Groundwork event.
     *
     * @return  null if this is not a Groundwork event.
     */
    int groundworkId();
    Optional<IGroundwork> groundwork();

    /**
     *	The owning PlantSpecies.
     *
     *	@return	the PlantSpecies
     */
    IPlantSpecies plantSpecies();

    /**
     *	The owning PlantVariety.
     *
     *	@return	the PlantVariety
     */
    public Optional<IPlantVariety> plantVariety();

    /**
     * The owning Location
     */
    public Optional<ILocation> location();


    /**
     * Check if this bean is for a Location in a previously specified list of target Locations.
     *
      * @return true if this bean is for a target Location
     */
    boolean targetLocation();

}
