/*
 *
 *  Copyright (C) 2021 Andrew Gegg
 *
 * 	This file is part of the Gardeners Notebook application
 *
 *  The Gardeners Notebook application is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 *
 *
 */

package uk.co.gardennotebook.spi;

import java.util.List;

/**
 * Actual or intended planting details for a CroppingPlan.
 *
 *	@author	Andy Gegg
 *	@version	3.0.0
 *	@since	3.0.0
 */

public interface ICroppingActualLister
{
    /**
     *	Returns the CroppingActual entries matching the given criteria.
     *	If no criteria have been specified all CroppingActual entries will be returned.
     *	Criteria are applied additively (i.e. criterion AND criterion).
     *
     *	@return	A list of CroppingActual entries matching previously specified criteria.
     *
     *	@throws	GNDBException	If the underlying persistence store (e.g. a database) throws an exception.
     *			The causal Exception can be retrieved via <code>getCause()</code>
     */
    public List<? extends ICroppingActual> fetch() throws GNDBException;

    /**
     *	Select only these CroppingActual entries
     *	May be called repeatedly to add to the list of CroppingActual entries to be returned
     *
     *	@param items	the list of CroppingActual entries.  A null value or empty list is a null-op
     *	@return	this Lister
     */
    public ICroppingActualLister croppingActual(ICroppingActual... items);

    /**
     *	Select only these CroppingActual entries
     *	May be called repeatedly to add to the list of CroppingActual entries to be returned
     *
     *	@param items	the list of CroppingActual entries.  A null value or empty list is a null-op
     *	@return	this Lister
     */
    public ICroppingActualLister croppingActual(List<ICroppingActual> items);

    /**
     *	Select only those CroppingActual entries which are for these CroppingPlan entries.
     *	May be called repeatedly to add to the list of CroppingPlan entries to be selected.
     *
     *	@param items	the list of CroppingActual items.  A null value or empty list is a null-op
     *	@return	this Lister
     */
    public ICroppingActualLister croppingPlan(ICroppingPlan... items);

    /**
     *	Select only those CroppingActual entries which are for these CroppingPlan entries.
     *	May be called repeatedly to add to the list of CroppingPlan entries to be selected
     *
     *	@param items	the list of CroppingPlan items.  A null value or empty list is a null-op
     *	@return	this Lister
     */
    public ICroppingActualLister croppingPlan(List<ICroppingPlan> items);

    /**
     *	Select only those CroppingActual entries which are for these PlantSpecies entries.
     *	May be called repeatedly to add to the list of PlantSpecies entries to be selected.
     *	If PlantSpecies and PlantVariety lists are BOTH supplied, CroppingActual entries matching either will be selected.
     *
     *	@param items	the list of PlantSpecies items.  A null value or empty list is a null-op
     *	@return	this Lister
     */
    public ICroppingActualLister plantSpecies(IPlantSpecies... items);

    /**
     *	Select only those CroppingActual entries which are for these PlantSpecies entries.
     *	May be called repeatedly to add to the list of PlantSpecies entries to be selected
     *	If PlantSpecies and PlantVariety lists are BOTH supplied, CroppingActual entries matching either will be selected.
     *
     *	@param items	the list of PlantSpecies items.  A null value or empty list is a null-op
     *	@return	this Lister
     */
    public ICroppingActualLister plantSpecies(List<IPlantSpecies> items);

    /**
     *	Select only those CroppingActual entries which are for these PlantVariety entries.
     *	May be called repeatedly to add to the list of PlantVariety entries to be selected.
     *	If PlantSpecies and PlantVariety lists are BOTH supplied, CroppingActual entries matching either will be selected.
     *
     *	@param items	the list of PlantVariety items.  A null value or empty list is a null-op
     *	@return	this Lister
     */
    public ICroppingActualLister plantVariety(IPlantVariety... items);

    /**
     *	Select only those CroppingActual entries which are for these PlantVariety entries.
     *	May be called repeatedly to add to the list of PlantVariety entries to be selected
     *	If PlantSpecies and PlantVariety lists are BOTH supplied, CroppingActual entries matching either will be selected.
     *
     *	@param items	the list of PlantVariety items.  A null value or empty list is a null-op
     *	@return	this Lister
     */
    public ICroppingActualLister plantVariety(List<IPlantVariety> items);

}
