/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	Do not edit this file, it is generated.
 */

package uk.co.gardennotebook.spi;

import java.util.List;

import java.time.*;

/**
These are the various afflictions observed.
*/
public interface IAfflictionLister
{
	/**
	*	Returns the Affliction entries matching the given criteria.
	*	If no criteria have been specified all Affliction entries will be returned.
	*	Criteria are applied additively (i.e. criterion AND criterion).
	*
	*	@return	A list of Affliction entries matching previously specified criteria.
	*
	*	@throws	GNDBException	If the underlying persistence store (e.g. a database) throws an exception.
	*			The causal Exception can be retrieved via <code>getCause()</code>
	*/
	public List<IAffliction> fetch() throws GNDBException;

	/**
	*	Select only these Affliction entries
	*	May be called repeatedly to add to the list of Affliction entries to be returned
	*
	*	@param items	the list of Affliction entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IAfflictionLister affliction(IAffliction... items);

	/**
	*	Select only these Affliction entries
	*	May be called repeatedly to add to the list of Affliction entries to be returned
	*
	*	@param items	the list of Affliction entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IAfflictionLister affliction(List<IAffliction> items);

	/**
	*	Select only those Affliction entries which are for these AfflictionClass entries.
	*	May be called repeatedly to add to the list of AfflictionClass entries to be selected.
	*
	*	@param items	the list of AfflictionClass items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IAfflictionLister afflictionClass(IAfflictionClass... items);

	/**
	*	Select only those Affliction entries which are for these AfflictionClass entries.
	*	May be called repeatedly to add to the list of AfflictionClass entries to be selected
	*
	*	@param items	the list of AfflictionClass items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IAfflictionLister afflictionClass(List<IAfflictionClass> items);

	/**
	*	Select only the Affliction entries with these names
	*	May be called repeatedly to add to the list of names to be selected
	*
	*	@param items	the list of name values.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IAfflictionLister name(String... items);

}
