/*
 * Copyright (C) 2018, 2021 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	Change log
    3.0.0	'key' selector renamed afflictionClass for consistency
 */

package uk.co.gardennotebook.spi;

import java.util.List;

/**
Groups the types of affliction - pest, disease, death
*/
public interface IAfflictionClassLister
{
	/**
	*
	*	Returns the AfflictionClass entries matching the given criteria
	*	If no criteria have been specified all AfflictionClass entries will be returned
	*	Criteria are applied additively (i.e. criterion AND criterion)
	*
	*	@return	A list of AfflictionClass entries matching previously specified criteria
	*
	*	@throws	GNDBException	If the underlying persistence store (e.g. a database) throws an exception.
	*			The causal Exception can be retrieved via <code>getCause()</code>
	*/
	public List<IAfflictionClass> fetch() throws GNDBException;

	/**
	*
	*	Select only these AfflictionClass entries
	*	May be called repeatedly to add to the list of AfflictionClass entries to be returned
	*
	*	@param items	the list of AfflictionClass entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IAfflictionClassLister afflictionClass(IAfflictionClass... items);
	/**
	*
	*	Select only these AfflictionClass entries
	*	May be called repeatedly to add to the list of AfflictionClass entries to be returned
	*
	*	@param items	the list of AfflictionClass entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IAfflictionClassLister afflictionClass(List<IAfflictionClass> items);

	/**
	*
	*	Select only the AfflictionClass entries with these name values
	*	May be called repeatedly to add to the list of name entries to be selected
	*
	*	@param items	the list of name values.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IAfflictionClassLister name(String... items);

}
