/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
	WARNING
	This file is NOT generated.
 */

package uk.co.gardennotebook;

import java.io.IOException;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * The controller class for the Catalogues tab
 *
 * @author Andy Gegg
*	@version	1.0
*	@since	1.0
 */
final class TopCatalogues extends AnchorPane implements  INotebookLoadable {

	private static final Logger LOGGER = LogManager.getLogger();

	@FXML
	private ResourceBundle resources;

	private Consumer<Node> loadSplit;
	private Consumer<Node> clearSplit;
	private BiConsumer<String, Node> loadTab;
	private Consumer<Node> clearTab;
	
	 TopCatalogues()
	{
        FXMLLoader fxmlLoader = new FXMLLoader(getClass().getResource("/fxml/TopCatalogues.fxml"),
			ResourceBundle.getBundle("notebook"));
        fxmlLoader.setRoot(this);
        fxmlLoader.setController(this);

        try {
            fxmlLoader.load();
        } catch (IOException exception) {
            throw new RuntimeException(exception);
        }
	}


	@Override
	public void setLoadSplit(Consumer<Node> code)
	{
		loadSplit = code;
	}
	
	@Override
	public void setClearSplit(Consumer<Node> code)
	{
		clearSplit = code;
	}
	
	@Override
	public void setLoadTab(BiConsumer<String, Node> code)
	{
		loadTab = code;
	}
	
	@Override
	public void setClearTab(Consumer<Node> code) {
		clearTab = code;
	}
    
    @FXML
    private void btnTopPlantCatalogueOnAction(ActionEvent event) {
		PlantCatalogueTab customTest = new PlantCatalogueTab();
		loadTab.accept(resources.getString("tab.plantcatalogue"), customTest);
	}

    @FXML
    private void btnTopAfflictionsOnAction(ActionEvent event) {
		AfflictionCat customTest = new AfflictionCat();
		loadTab.accept(resources.getString("tab.afflictioncatalogue"), customTest);
	}

	@FXML
	private void btnTopLocationsOnAction(ActionEvent event) {
		LocationCat customTest = new LocationCat();
		loadTab.accept(resources.getString("tab.locationcatalogue"), customTest);
	}

	@FXML
    private void btnTopRetailersOnAction(ActionEvent event) {
		RetailerCat customTest = new RetailerCat();
		loadTab.accept(resources.getString("tab.retailercatalogue"), customTest);
	}

    @FXML
    private void btnTopBrandsOnAction(ActionEvent event) {
		ProductBrandCat customTest = new ProductBrandCat();
		loadTab.accept(resources.getString("tab.productbrandcatalogue"), customTest);
	}

    @FXML
    private void btnTopProductsOnAction(ActionEvent event) {
		ProductCat customTest = new ProductCat();
		loadTab.accept(resources.getString("tab.productcatalogue"), customTest);
	}

    @FXML
    private void btnTopProductCategoriesOnAction(ActionEvent event) {
		ProductCategoryCat customTest = new ProductCategoryCat();
		loadTab.accept(resources.getString("tab.productcategorycatalogue"), customTest);
	}

    @FXML
    private void btnTopHusbandryClassesOnAction(ActionEvent event) {
		HusbandryClassCat customTest = new HusbandryClassCat();
		loadTab.accept(resources.getString("tab.husbandryclasscatalogue"), customTest);
	}

    @FXML
    private void btnTopGroundworkActivitiesOnAction(ActionEvent event) {
		GroundworkActivityCat customTest = new GroundworkActivityCat();
		loadTab.accept(resources.getString("tab.groundworkactivitycatalogue"), customTest);
    }

    @FXML
    private void btnTopWeatherConditionsOnAction(ActionEvent event) {
		WeatherConditionCat customTest = new WeatherConditionCat();
		loadTab.accept(resources.getString("tab.weatherconditioncatalogue"), customTest);
	}

    @FXML
    private void btnTopWildlifeSpeciesOnAction(ActionEvent event) {
		WildlifeSpeciesCat customTest = new WildlifeSpeciesCat();
		loadTab.accept(resources.getString("tab.wildlifespeciescatalogue"), customTest);
	}

	@FXML
	private void tabOnCloseRequest(Event e)
	{
		clearSplit.accept(this);
	}

}
