/*
 * Copyright (C) 2018-2020 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
	Change log
	2.6.1   Code tidy-up
 */

package uk.co.gardennotebook;

import java.io.IOException;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * The controller class for the Shopping tab
 *
 * @author Andy Gegg
*	@version	2.6.1
*	@since	1.1.0
 */
final class ShopCatalogues extends AnchorPane implements  INotebookLoadable {

	private static final Logger LOGGER = LogManager.getLogger();

	@FXML
	private ResourceBundle resources;

	private Consumer<Node> loadSplit;
	private Consumer<Node> clearSplit;
	private BiConsumer<String, Node> loadTab;
	private Consumer<Node> clearTab;
	
	ShopCatalogues()
	{
        FXMLLoader fxmlLoader = new FXMLLoader(getClass().getResource("/fxml/ShopCatalogues.fxml"),
			ResourceBundle.getBundle("notebook"));
        fxmlLoader.setRoot(this);
        fxmlLoader.setController(this);

        try {
            fxmlLoader.load();
        } catch (IOException exception) {
            throw new RuntimeException(exception);
        }
	}

	@Override
	public void setLoadSplit(Consumer<Node> code)
	{
		loadSplit = code;
	}
	
	@Override
	public void setClearSplit(Consumer<Node> code)
	{
		clearSplit = code;
	}
	
	@Override
	public void setLoadTab(BiConsumer<String, Node> code)
	{
		loadTab = code;
	}
	
	@Override
	public void setClearTab(Consumer<Node> code) {
		clearTab = code;
	}
    
	@FXML
    private void btnPurchaseAddOnAction(ActionEvent event)
	{
		PurchaseEditor tabCon = new PurchaseEditor();
		loadTab.accept(resources.getString("tab.purchase"), tabCon);
	}

    @FXML
    private void btnShoppingListOnAction(ActionEvent event) {
		ShoppingListCat customTest = new ShoppingListCat();
		loadTab.accept(resources.getString("tab.shoppinglist"), customTest);
	}

    @FXML
    private void btnTopRetailersOnAction(ActionEvent event) {
		RetailerCat customTest = new RetailerCat();
		loadTab.accept(resources.getString("tab.retailercatalogue"), customTest);
	}

    @FXML
    private void btnTopBrandsOnAction(ActionEvent event) {
		ProductBrandCat customTest = new ProductBrandCat();
		loadTab.accept(resources.getString("tab.productbrandcatalogue"), customTest);
	}

    @FXML
    private void btnTopProductsOnAction(ActionEvent event) {
		ProductCat customTest = new ProductCat();
		loadTab.accept(resources.getString("tab.productcatalogue"), customTest);
	}

    @FXML
    private void btnTopProductCategoriesOnAction(ActionEvent event) {
		ProductCategoryCat customTest = new ProductCategoryCat();
		loadTab.accept(resources.getString("tab.productcategorycatalogue"), customTest);
	}

	@FXML
	private void tabOnCloseRequest(Event e)
	{
		clearSplit.accept(this);
	}


}
