/*
 * Copyright (C) 2019, 2021 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
	Change log
    2.9.6	When a Diary entry is added/changed, make sure updated comments are shown
 */

package uk.co.gardennotebook;

import java.util.ResourceBundle;
import javafx.scene.control.TreeTableCell;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.EntryMessage;

/**
 *
	*	@author	Andy Gegg
	*	@version	2.9.6
	*	@since	2.3.0
 */
final class ProductTreeCommentCell extends TreeTableCell<ProductTreeBean, ProductTreeBean> {

    private static final Logger LOGGER = LogManager.getLogger();

    private final CommentCellImpl trueCell;
    private double cellHeight;

    ProductTreeCommentCell(ResourceBundle resources) {
    trueCell = new CommentCellImpl(resources);
}

    @Override
    protected void updateItem(ProductTreeBean item, boolean empty) {
        EntryMessage log4jEntryMsg = LOGGER.traceEntry("updateItem(): item:{}",item);
        super.updateItem(item, empty);
        if (item == null || empty) {
            setText(null);
            setGraphic(null);
            return;
        }
        cellHeight = this.getHeight();
        trueCell.setParent(item.getItem());	//	2.9.6
        trueCell.updateViewMode(this, item.getComments());
    }

    @Override
    public void startEdit() {
        EntryMessage log4jEntryMsg = LOGGER.traceEntry("startEdit()");
        super.startEdit();
        cellHeight = this.getHeight();
        trueCell.setParent(getItem().getItem());
        trueCell.updateViewMode(this, getItem().getComments());
    }

    @Override
    public void cancelEdit() {
        EntryMessage log4jEntryMsg = LOGGER.traceEntry("cancelEdit()");
        super.cancelEdit();
        trueCell.updateViewMode(this, getItem().getComments());
        this.setPrefHeight(cellHeight);
    }
    
}
