/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	Do not edit this file, it is generated.
 */

package uk.co.gardennotebook;

import uk.co.gardennotebook.spi.GNDBException;
import uk.co.gardennotebook.spi.GNDBRuntimeException;

import uk.co.gardennotebook.fxbean.PlantVarietyBean;
import uk.co.gardennotebook.fxbean.PlantSpeciesBean;
import javafx.beans.property.SimpleObjectProperty;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.EntryMessage;
import org.apache.logging.log4j.Level;

/**
	*	A particular variety of a plant species.
 *	Note that the common name is NOT a unique value as different species may have varieties with the same name - e.g. Money Maker tomato AND aubergine.
 *	Note the use of a Trigger to reflect changes to commonName into Product.
	*
	*	Must be public to be loaded by FXML
	*
	*	@author	Andy Gegg
	*	@version	1.1.0
	*	@since	1.0
*/
final public class PlantVarietyCombo extends DiaryEntryCombo<PlantVarietyBean>
{
	private static final Logger LOGGER = LogManager.getLogger();

	private final SimpleObjectProperty<PlantSpeciesBean> plantSpecies = new SimpleObjectProperty<>(this, "ParentPlantSpecies", null);

	//	need a no-args constructor for FXML Loader
	public PlantVarietyCombo()
	{
		super();
		super.currentValue = null;
		this.valueProperty().addListener((obs, oldVal, newVal)-> {
					if (plantSpeciesProperty().getValue() != null) return;
					if (newVal == null) return;
					plantSpeciesProperty().set(newVal.getPlantSpecies());
					this.setValue(newVal);
		});

		plantSpecies.addListener((obs, oldVal, newVal) -> {
				if (newVal == null)
				{
					this.getItems().clear();
					this.setValue(null);
				}
				else if (oldVal != null && oldVal.getKey().equals(plantSpeciesProperty().getValue().getKey()))
				{// not actually changed - can happen during initialisation
					return;
				}
				else
				{
					try
					{
						this.getItems().setAll(PlantVarietyBean.fetchAll(newVal));
					} catch (GNDBException ex) {
						PanicHandler.panic(ex);
					}
					this.setValue(null);
				}
		});
	}

	public PlantVarietyCombo(PlantSpeciesBean parent)
	{
		this();
		plantSpeciesProperty().set(parent);
	}

	public PlantVarietyCombo(PlantSpeciesBean parent, PlantVarietyBean initialVal)
	{
		this(parent);
		this.setValue(initialVal);
		super.currentValue = initialVal;
	}

	SimpleObjectProperty<PlantSpeciesBean> plantSpeciesProperty()
	{
		return plantSpecies;
	}

	@Override
	String getName(PlantVarietyBean item)
	{
		EntryMessage log4jEntryMsg = LOGGER.traceEntry("getName({})", item);
		if (item == null)
		{
			return "";
		}
		if (item instanceof PlantVarietyBean)
		{
			return ((PlantVarietyBean)item).getCommonName();
		}
		else
		{
			throw new UnsupportedOperationException("PlantVarietyCombo: getName: unknown object in converter: "+item);
		}
	}	//	getName()

	@Override
	PlantVarietyBean newItem(String name)
	{
		EntryMessage log4jEntryMsg = LOGGER.traceEntry("newItem({})", name);
		if (name == null || name.isEmpty())
		{
			return null;
		}
		PlantVarietyBean added = new PlantVarietyBean();
		added.setPlantSpecies(plantSpeciesProperty().getValue());
		added.setCommonName(name);
		try
		{
			added.save();
		} catch (GNDBException ex) {
			PanicHandler.panic(ex);
		}
		return LOGGER.traceExit(log4jEntryMsg,added);
	}	//	newItem()
}
