/*
 * Copyright (C) 2018 Andrew Gegg
 
 *
 *   This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software:  you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	This file is NOT generated.
 */

package uk.co.gardennotebook;

import java.io.IOException;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.Label;

/**
 * Controller for a Tooltip used by the PlantCatalogue to show plant details
 *
 * @author Andy Gegg
*	@version	1.1.1
*	@since	1.1.0
 */
final class PlantDetailsTooltip extends Tooltip 
{

	private PlantCatalogueBean thisValueBean;

	@FXML
	private ResourceBundle resources;

	@FXML
	private Label lblCommonName;
	@FXML
	private TextField fldUtility;
	@FXML
	private TextField fldHardiness;
	@FXML
	private TextField fldLifeType;
	@FXML
	private TextField fldPlantType;
	
	PlantDetailsTooltip(PlantCatalogueBean initialVal)
	{
		if (initialVal == null)
			return;
		
		this.thisValueBean = initialVal;
		
		FXMLLoader fxmlLoader = new FXMLLoader(getClass().getResource("/fxml/PlantDetailsTooltip.fxml"),
			ResourceBundle.getBundle("notebook") );
		fxmlLoader.setRoot(this);
		fxmlLoader.setController(this);
		try {
			fxmlLoader.load();	// NB initialize is called from in here
		} catch (IOException exception) {
			throw new RuntimeException(exception);
		}
	}
	
	/*
	 * Initializes the controller class.
	 */
	@FXML
	private void initialize() 
	{
        lblCommonName.textProperty().bind(thisValueBean.commonNameProperty());
		fldUtility.textProperty().bindBidirectional(thisValueBean.utilityProperty());
		fldUtility.setTextFormatter(MaxLengthTextFormatter.getFormatter(45));
		fldHardiness.textProperty().bindBidirectional(thisValueBean.hardinessProperty());
		fldHardiness.setTextFormatter(MaxLengthTextFormatter.getFormatter(45));
		fldLifeType.textProperty().bindBidirectional(thisValueBean.lifeTypeProperty());
		fldLifeType.setTextFormatter(MaxLengthTextFormatter.getFormatter(45));
		fldPlantType.textProperty().bindBidirectional(thisValueBean.plantTypeProperty());
		fldPlantType.setTextFormatter(MaxLengthTextFormatter.getFormatter(45));
	}	
	
}
