/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	This file is NOT generated.
 */

package uk.co.gardennotebook;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.TreeItem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.EntryMessage;

/**
 *
	*	@author Andy Gegg
	*	@version	3.0.0
	*	@since	3.0.0
 */
final class PlantCatalogueBeanSimpleTreeItem extends TreeItem<PlantCatalogueBean> {

	private static final Logger LOGGER = LogManager.getLogger();

	PlantCatalogueBeanSimpleTreeItem(PlantCatalogueBean val){
		super(val);
	}

	PlantCatalogueBeanSimpleTreeItem(){
		super();
	}
	
	boolean isFirstCall = true;
	
	@Override
	public ObservableList<TreeItem<PlantCatalogueBean>> getChildren() {
		EntryMessage log4jEntryMsg = LOGGER.traceEntry("getChildren() for: {}", (PlantCatalogueBean) this.getValue());
		if (isFirstCall)
		{
			isFirstCall = false;
			PlantCatalogueBean val = this.getValue();
			if (val == null) return FXCollections.emptyObservableList();
			ObservableList<PlantCatalogueBeanSimpleTreeItem> kids = FXCollections.<PlantCatalogueBeanSimpleTreeItem>observableArrayList();
			for (PlantCatalogueBean pc : val.getChildren())
				kids.add(new PlantCatalogueBeanSimpleTreeItem(pc));
			super.getChildren().setAll(kids);
		}
		LOGGER.traceExit();
		return super.getChildren();
	}
	
	@Override
	public boolean isLeaf() {
		return (this.getValue())
			.isLeaf();
	}

}
