/*
 * Copyright (C) 2023 Andrew Gegg
 
 *
 *   This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software:  you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
 *	Change log
 * 	3.2.1	Correct date display
 */

package uk.co.gardennotebook;

import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Label;
//import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
//import org.apache.logging.log4j.LogManager;
//import org.apache.logging.log4j.Logger;
import uk.co.gardennotebook.fxbean.LifecycleAnalysisBean;

import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ResourceBundle;

/**
 * Controller for a Tooltip used by the PlantCatalogue to show plant details
 *
 * @author Andy Gegg
*	@version	3.2.1
*	@since	3.2.0
 */
final class LifecycleAnalysisTooltip extends Tooltip
{
//	private static final Logger LOGGER = LogManager.getLogger();

	private LifecycleAnalysisBean thisValueBean;

	@FXML
	private ResourceBundle resources;

	@FXML
	private Label lblDate;
	@FXML
	private Label lblSpecies;
	@FXML
	private Label lblVariety;
	@FXML
	private Label lblActivity;
	@FXML
	private Label lblLocation;

	LifecycleAnalysisTooltip(LifecycleAnalysisBean initialVal)
	{
//		LOGGER.debug("Tooltip: constructor: bean: {}", initialVal);

		if (initialVal == null)
			return;
		
		this.thisValueBean = initialVal;
		
		FXMLLoader fxmlLoader = new FXMLLoader(getClass().getResource("/fxml/LifecycleAnalysisTooltip.fxml"),
			ResourceBundle.getBundle("notebook") );
		fxmlLoader.setRoot(this);
		fxmlLoader.setController(this);
		try {
			fxmlLoader.load();	// NB initialize is called from in here
		} catch (IOException exception) {
			throw new RuntimeException(exception);
		}
	}
	
	/*
	 * Initializes the controller class.
	 */
	@FXML
	private void initialize() 
	{
        lblDate.setText(thisValueBean.getDate().format(DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT)));
		lblSpecies.setText(thisValueBean.getPlantSpecies().getCommonName());
		if (thisValueBean.hasPlantVariety())
		{
			lblVariety.setText(thisValueBean.getPlantVariety().getCommonName());
		}

		if (thisValueBean.hasLocation())
		{
			lblLocation.setText(thisValueBean.getLocation().getName());
		}

//		LOGGER.debug("initialize: childType: {}", thisValueBean.getChildType());
		lblActivity.setText( switch(thisValueBean.getChildType())
		{
			case HUSBANDRY -> thisValueBean.getHusbandry().getHusbandryClass().getName();
			case GROUNDWORK -> thisValueBean.getGroundwork().getGroundworkActivity().getName();
			case AFFLICTIONEVENT -> thisValueBean.getAfflictionEvent().getAffliction().getName();
			default -> "unknown type "+thisValueBean.getChildType();
		});
	}
	
}
