/*
 * Copyright (C) 2018, 2022 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
	Change log
	3.0.5	Support Sales spanning
			Refactor as a Record
 */

package uk.co.gardennotebook;

import uk.co.gardennotebook.spi.GNDBException;
import uk.co.gardennotebook.spi.NotebookEntryType;

/**
 *	Tag the DiaryBean to enable a pretty display.
 *
 *	CSS is used to make the Diary readable - the date is shown only once for each day (date block or page):
 *		for Purchases the PurchaseItems are grouped under the Purchase, showing the Retailer only once;
 *		similarly, SaleItems are grouped under the Sale showing the buyer only once.
 *
 * @author Andy Gegg
*	@version	3.0.5
*	@since	1.0
 */
record IndexedDiaryBean(DiaryBean diaryBean,	//	the DiaryBean being indexed ('tagged')
						  int dateIndex,	// the number of the block (i.e. diary 'page' for this date, from 0)
						  int dateSpan,	// the number of rows in the date block
						  int inDateIndex,	// the number of the row WITHIN THE BLOCK for this bean, from 0
						  int purchaseSpan,	// the number of rows in the purchase block, including the Purchase row
						  int inPurchaseIndex,	// the number of the row within a purchase block, 0 is the Purchase row
						  int saleSpan,	// the number of rows in the sale block, including the Sale row
						  int inSaleIndex	// the number of the row within a sale block, 0 is the Sale row
						)
{

	DiaryBean getItem()
	{
		return diaryBean;
	}

	/**
	 * A convenience function.
	 *
	 * @return	the type of the wrapped DiaryBean.
	 */
	NotebookEntryType beanType() { return diaryBean.getItemType(); }
	
	boolean canDelete() throws GNDBException
	{
		return diaryBean.canDelete();
	}
	
	boolean hasAncestor() throws GNDBException
	{
		return diaryBean.hasAncestor();
	}

	boolean hasDescendant() throws GNDBException
	{
		return diaryBean.hasDescendant();
	}

}
