/*
* Copyright (C) 2018-2020 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
  * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	This file is NOT generated.
 */

package uk.co.gardennotebook;

import javafx.scene.control.TableCell;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.EntryMessage;
import uk.co.gardennotebook.fxbean.INotebookBean;

import java.util.ResourceBundle;

/**
 *	A convenience class to support editing Comments in the various item editors
 * 
	*	@author	Andy Gegg
	*	@version	2.9.6
	*	@since	1.0
 */
final class EditorCommentTableCell<T extends INotebookBean> extends TableCell<T, T>
{
	private static final Logger LOGGER = LogManager.getLogger();

	private final CommentCellImpl trueCell;
	private double cellHeight;

	EditorCommentTableCell(ResourceBundle resources)
	{
		trueCell = new CommentCellImpl(resources);
	}
	
	@Override
	protected void updateItem(T item, boolean empty)
	{
//		super.updateItem(item, empty);
		EntryMessage log4jEntryMsg = LOGGER.traceEntry("updateItem(): item:{}",item);
		super.updateItem(item, empty);
		if (item == null || empty)
		{
			setText(null);
			setGraphic(null);
			return;
		}

		cellHeight = this.getHeight();
		trueCell.setParent(item);	//	2.9.6
		trueCell.updateViewMode(this, item.getComments());
	}

	@Override
	public void startEdit()
    {
		EntryMessage log4jEntryMsg = LOGGER.traceEntry("startEdit()");
		super.startEdit();
		cellHeight = this.getHeight();
		trueCell.setParent(getItem());
		trueCell.updateViewMode(this, getItem().getComments());
	}

	@Override
	public void cancelEdit()
    {
		EntryMessage log4jEntryMsg = LOGGER.traceEntry("cancelEdit()");
		super.cancelEdit();
		trueCell.updateViewMode(this, getItem().getComments());
		this.setPrefHeight(cellHeight);
	}
}
	
