/*
 *
 *  Copyright (C) 2022 Andrew Gegg
 *
 * 	This file is part of the Gardeners Notebook application
 *
 *  The Gardeners Notebook application is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 *
 *
 */

package uk.co.gardennotebook;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableView;
import uk.co.gardennotebook.fxbean.CommentBean;
import uk.co.gardennotebook.fxbean.INotebookBean;

/**
 *  A convenience class to enable adding new comments in the Comments Table in Editors
 *
 */
public class EditorCommentAdder<T extends INotebookBean> implements ChangeListener<String>
{
    private final T parent;
    private final TableView<CommentBean> tbvComment;

    EditorCommentAdder(T parent, TableView<CommentBean> tbvComment)
    {
        this.parent = parent;
        this.tbvComment = tbvComment;
    }

    @Override
    public void changed(ObservableValue<? extends String> obj, String oldVal, String newVal) {
        if ((newVal !=null) && !(newVal.isEmpty()))
        {
            CommentBean cb_extra = new CommentBean(parent);
            cb_extra.commentProperty().addListener(this);
            tbvComment.getItems().add(cb_extra);
            obj.removeListener(this);
        }
    }
}
