/*
 *
 *  Copyright (C) 2021 Andrew Gegg
 *
 * 	This file is part of the Gardeners Notebook application
 *
 *  The Gardeners Notebook application is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 *
 *
 */

package uk.co.gardennotebook.mysql;

import org.junit.jupiter.api.BeforeAll;
import uk.co.gardennotebook.spi.NotebookEntryType;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;

import static org.junit.jupiter.api.Assertions.*;

class WildlifeSpeciesTest
{
    private static WildlifeSpecies myTest;
    private static WildlifeSpecies myTest2 ;
    private static WildlifeSpecies myTest3;
    private static Review myReview;

    @BeforeAll
    static void setUp()
    {
        myTest = new WildlifeSpecies(1, "test name", "test description", LocalDateTime.now(), LocalDateTime.now());
        Comment comm1 = new Comment(101, 1, "WS", LocalDate.now(), "First comment", LocalDateTime.now(), LocalDateTime.now());
        Comment comm2 = new Comment(102, 1, "WS", LocalDate.now(), "Second comment", LocalDateTime.now(), LocalDateTime.now());
        myTest2 = new WildlifeSpecies(2, "test species", "description of species", LocalDateTime.now(), LocalDateTime.now(), comm1);
        myTest3 = new WildlifeSpecies(myTest2, comm2);
        myReview = new Review(1, LocalDate.now(), Year.now(), null, null, "test review", "description of review", LocalDateTime.now(), LocalDateTime.now(), null);
    }

    @org.junit.jupiter.api.Test
    void getId()
    {
        assertEquals(1, myTest.getId());
    }

    @org.junit.jupiter.api.Test
    void getKey()
    {
        assertEquals(1, myTest.getKey());
    }

    @org.junit.jupiter.api.Test
    void getType()
    {
        assertEquals(NotebookEntryType.WILDLIFESPECIES, myTest.getType());
    }

    @org.junit.jupiter.api.Test
    void getName()
    {
        assertEquals("test name", myTest.getName());
    }

    @org.junit.jupiter.api.Test
    void getDescription()
    {
        assertEquals("test description", myTest.getDescription().orElse("no description"));
    }

//    @org.junit.jupiter.api.Test
//    void getLastUpdated()
//    {
//    }
//
//    @org.junit.jupiter.api.Test
//    void getCreated()
//    {
//    }
//
    @org.junit.jupiter.api.Test
    void sameAs()
    {
        assertTrue(myTest.sameAs(myTest));
        assertFalse(myTest.sameAs(null));
        assertFalse(myTest.sameAs(myTest2));
        assertFalse(myTest.sameAs(myReview));
    }
//
//    @org.junit.jupiter.api.Test
//    void getWildlife()
//    {
//    }

    @org.junit.jupiter.api.Test
    void getComments()
    {
        assertEquals(0, myTest.getComments().size());
        assertEquals(1, myTest2.getComments().size());
        assertEquals("First comment", myTest2.getComments().get(0).getComment());
        assertEquals(2, myTest3.getComments().size());
        assertEquals("First comment", myTest3.getComments().get(0).getComment());
        assertEquals("Second comment", myTest3.getComments().get(1).getComment());
    }

//    @org.junit.jupiter.api.Test
//    void toJson()
//    {
//    }
//
//    @org.junit.jupiter.api.Test
//    void testToString()
//    {
//    }
}