/*
 *
 *  Copyright (C) 2021 Andrew Gegg
 *
 * 	This file is part of the Gardeners Notebook application
 *
 *  The Gardeners Notebook application is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 *
 *
 */

package uk.co.gardennotebook.mysql;

import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import uk.co.gardennotebook.spi.NotebookEntryType;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;

import static org.junit.jupiter.api.Assertions.*;

class ReviewTest
{

    private static Review myTest;
    private static Review myTest2 ;
    private static Review myTest3;
    private static WildlifeSpecies myWildlife;

    @BeforeAll
    static void setUp()
    {
        myTest = new Review(1, LocalDate.now(), Year.now(), null, null, "test review", "description of review", LocalDateTime.now(), LocalDateTime.now(), null);
        Comment comm1 = new Comment(101, 1, "WS", LocalDate.now(), "First comment", LocalDateTime.now(), LocalDateTime.now());
        Comment comm2 = new Comment(102, 1, "WS", LocalDate.now(), "Second comment", LocalDateTime.now(), LocalDateTime.now());
        myTest2 = new Review(2, LocalDate.now(), Year.now(), Year.now().atDay(1), Year.now().atDay(365), "test review", "description of review",  LocalDateTime.now(), LocalDateTime.now(), comm1);
        myTest3 = new Review(myTest2, comm2);
        myWildlife = new WildlifeSpecies(1, "test species", "description of species", LocalDateTime.now(), LocalDateTime.now());
    }

    @Test
    void getId()
    {
        assertEquals(1, myTest.getId());
    }

    @Test
    void getKey()
    {
        assertEquals(1, myTest.getId());
    }

    @Test
    void getType()
    {
        assertEquals(NotebookEntryType.REVIEW, myTest.getType());
    }

    @Test
    void getDate()
    {
        assertEquals(myTest.getDate(), LocalDate.now());
    }

    @Test
    void getYearInReview()
    {
        assertEquals(myTest.getYearInReview(), Year.now()  );
    }

    @Test
    void getCoverFrom()
    {
        assertTrue(myTest.getCoverFrom().isEmpty());
        assertEquals(myTest2.getCoverFrom().orElse(null), Year.now().atDay(1)  );
    }

    @Test
    void getCoverTo()
    {
        assertTrue(myTest.getCoverTo().isEmpty());
        assertEquals(myTest2.getCoverTo().orElse(null), Year.now().atDay(365)  );
    }

    @Test
    void getTitle()
    {
        assertEquals("test review", myTest.getTitle());
    }

    @Test
    void getDescription()
    {
        assertEquals("description of review", myTest.getDescription().orElse("no description"));
    }

    @Test
    void sameAs()
    {
        assertTrue(myTest.sameAs(myTest));
        assertFalse(myTest.sameAs(null), "null test");
        assertFalse(myTest.sameAs(myTest2), "different review");
        assertFalse(myTest.sameAs(myWildlife), "different notebook type");
    }

    @Test
    void getComments()
    {
        assertEquals(0, myTest.getComments().size());
        assertEquals(1, myTest2.getComments().size());
        assertEquals("First comment", myTest2.getComments().get(0).getComment());
        assertEquals(2, myTest3.getComments().size());
        assertEquals("First comment", myTest3.getComments().get(0).getComment());
        assertEquals("Second comment", myTest3.getComments().get(1).getComment());
    }

    @Test
    void toJson()
    {
    }

    @Test
    void testToString()
    {
    }
}