/*
 *
 *  Copyright (C) 2021 Andrew Gegg
 *
 * 	This file is part of the Gardeners Notebook application
 *
 *  The Gardeners Notebook application is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 *
 *
 */

package uk.co.gardennotebook.mysql;

import org.junit.jupiter.api.*;
import uk.co.gardennotebook.spi.GNDBException;
import uk.co.gardennotebook.spi.ICropRotationGroup;
import uk.co.gardennotebook.spi.ICroppingPlan;

import java.time.Year;
import java.util.List;

import static org.junit.jupiter.api.Assertions.*;

@TestInstance(TestInstance.Lifecycle.PER_CLASS)
@TestMethodOrder(MethodOrderer.OrderAnnotation.class)
class CroppingPlanListerTest
{
    static ICroppingPlan plan1 = null;
    static ICroppingPlan plan2 = null;
    static ICroppingPlan plan3 = null;

    @BeforeAll
    static void startUp()
    {
        SQLTrug myTrug = new SQLTrug();
        myTrug.getServers();
        DBConnection.forceConnectionString(DBConnection.RDBMS_ENUM.MySQL,"jdbc:mysql://localhost:3306/gardennotebook?user=root&password=password&useSSL=false&allowPublicKeyRetrieval=true&sslMode=DISABLED&connectTimeout=1000&cachePrepStmts=true&prepStmtCacheSize=250&prepStmtCacheSqlLimit=2048&maintainTimeStats=false&disableMariaDbDriver=true&serverTimezone=UTC");

        //  populate caches
        try
        {
            new CropRotationGroupLister().fetch();
            new LocationLister().fetch();
        }
        catch (GNDBException e)
        {
            e.printStackTrace();
        }
        CroppingPlanBuilder bld = new CroppingPlanBuilder();
        bld.cropRotationGroupId(1);
        bld.locationId(1);
        bld.yearOfPlan(Year.now());
        try
        {
            plan1 = bld.save();
        }
        catch (GNDBException e)
        {
            e.printStackTrace();
        }
        bld = new CroppingPlanBuilder();
        bld.cropRotationGroupId(2);
        bld.locationId(1);
        bld.yearOfPlan(Year.now());
        try
        {
            plan2 = bld.save();
        }
        catch (GNDBException e)
        {
            e.printStackTrace();
        }
        bld = new CroppingPlanBuilder();
        bld.cropRotationGroupId(2);
        bld.locationId(1);
        bld.yearOfPlan(Year.now().plusYears(1));
        try
        {
            plan3 = bld.save();
        }
        catch (GNDBException e)
        {
            e.printStackTrace();
        }
//        System.out.println("plan1: "+plan1);
//        System.out.println("plan2: "+plan2);
//        System.out.println("plan3: "+plan3);
    }

   @AfterAll
    void tearDown()
    {
        CroppingPlanBuilder bld = new CroppingPlanBuilder(plan1);
        try
        {
            bld.delete();
        }
        catch (GNDBException e)
        {
            e.printStackTrace();
        }
        bld = new CroppingPlanBuilder(plan2);
        try
        {
            bld.delete();
        }
        catch (GNDBException e)
        {
            e.printStackTrace();
        }
        bld = new CroppingPlanBuilder(plan3);
        try
        {
            bld.delete();
        }
        catch (GNDBException e)
        {
            e.printStackTrace();
        }
    }

    @BeforeEach
    void setUp()
    {
//        CroppingPlanBuilder bld = new CroppingPlanBuilder();
//        bld.cropRotationGroupId(1);
//        bld.locationId(1);
//        bld.yearOfPlan(Year.now());
//        try
//        {
//            plan1 = bld.save();
//        }
//        catch (GNDBException e)
//        {
//            e.printStackTrace();
//        }
    }

    @Test
    @Order(100)
    void fetch()
    {
        try
        {
            List<? extends ICroppingPlan> list = new CroppingPlanLister().fetch();
            assertEquals(3, list.size());
        }
        catch (GNDBException e)
        {
            e.printStackTrace();
        }
    }

//    @Test
//    void id()
//    {
//    }
//
//    @Test
//    void croppingPlan()
//    {
//    }
//
//    @Test
//    void testCroppingPlan()
//    {
//    }

    @Test
    @Order(200)
    void cropRotationGroup()
    {
        ICropRotationGroup crg = null;
        try
        {
            crg = new CropRotationGroupLister().id(1).fetch().get(0);
        }
        catch (GNDBException e)
        {
            e.printStackTrace();
        }
        try
        {
            List<? extends ICroppingPlan> list = new CroppingPlanLister().cropRotationGroup(crg).fetch();
            assertEquals(1, list.size());
        }
        catch (GNDBException e)
        {
            e.printStackTrace();
        }
    }

    @Test
    @Order(201)
    void testCropRotationGroup()
    {
        ICropRotationGroup crg = null;
        try
        {
            crg = new CropRotationGroupLister().id(2).fetch().get(0);
        }
        catch (GNDBException e)
        {
            e.printStackTrace();
        }
        try
        {
            List<? extends ICroppingPlan> list = new CroppingPlanLister().cropRotationGroup(crg).fetch();
            assertEquals(2, list.size());
        }
        catch (GNDBException e)
        {
            e.printStackTrace();
        }
    }

//    @Test
//    void location()
//    {
//    }
//
//    @Test
//    void testLocation()
//    {
//    }

    @Test
    @Order(202)
    void yearOfPlan()
    {
        try
        {
            List<? extends ICroppingPlan> list = new CroppingPlanLister().yearOfPlan(Year.now()).fetch();
            assertEquals(2, list.size());
            assertEquals(Year.now(), list.get(0).getYearOfPlan());
            assertEquals(Year.now(), list.get(1).getYearOfPlan());
        }
        catch (GNDBException e)
        {
            e.printStackTrace();
        }
    }

    @Test
    @Order(203)
    void testYearOfPlan()
    {
        try
        {
            List<? extends ICroppingPlan> list = new CroppingPlanLister().yearOfPlan(Year.now().plusYears(1)).fetch();
            assertEquals(1, list.size());
            assertEquals(Year.now().plusYears(1), list.get(0).getYearOfPlan());
        }
        catch (GNDBException e)
        {
            e.printStackTrace();
        }
    }

    @Test
    @Order(203)
    void testYearOfPlanFail()
    {
        try
        {
            List<? extends ICroppingPlan> list = new CroppingPlanLister().yearOfPlan(Year.now().plusYears(3)).fetch();
            assertEquals(0, list.size());
        }
        catch (GNDBException e)
        {
            e.printStackTrace();
        }
    }

    @Test
    @Order(204)
    void testYearOfPlanMulti()
    {
        try
        {
            List<? extends ICroppingPlan> list = new CroppingPlanLister().yearOfPlan(Year.now()).yearOfPlan(Year.now().plusYears(1)).fetch();
            assertEquals(3, list.size());
        }
        catch (GNDBException e)
        {
            e.printStackTrace();
        }
    }

    @Test
    @Order(205)
    void testYearOfPlanMulti2()
    {
        try
        {
            List<? extends ICroppingPlan> list = new CroppingPlanLister().yearOfPlan(Year.now(), Year.now().plusYears(1)).fetch();
            assertEquals(3, list.size());
        }
        catch (GNDBException e)
        {
            e.printStackTrace();
        }
    }
}