/*
 *
 *  Copyright (C) 2021 Andrew Gegg
 *
 * 	This file is part of the Gardeners Notebook application
 *
 *  The Gardeners Notebook application is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 *
 *
 */

package uk.co.gardennotebook.mysql;

import org.junit.jupiter.api.*;
import uk.co.gardennotebook.spi.GNDBException;
import uk.co.gardennotebook.spi.ICropRotationGroup;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;

@TestInstance(TestInstance.Lifecycle.PER_CLASS)
class CropRotationGroupListerTest
{
    private static CropRotationGroupLister myTest;
    private static List<ICropRotationGroup> wss;
    private static List<ICropRotationGroup> wssCreated = new ArrayList<>(3);

    @BeforeAll
    static void startUp()
    {
        SQLTrug myTrug = new SQLTrug();
        myTrug.getServers();
        DBConnection.forceConnectionString(DBConnection.RDBMS_ENUM.MySQL,"jdbc:mysql://localhost:3306/gardennotebook?user=root&password=password&useSSL=false&allowPublicKeyRetrieval=true&sslMode=DISABLED&connectTimeout=1000&cachePrepStmts=true&prepStmtCacheSize=250&prepStmtCacheSqlLimit=2048&maintainTimeStats=false&disableMariaDbDriver=true&serverTimezone=UTC");
//
//        for (int ix = 1; ix < 4; ix++)
//        {
//            try
//            {
//                CropRotationGroupBuilder bld = new CropRotationGroupBuilder();
//                bld.name(ix + " species "+ LocalDateTime.now());
//                bld.description("test species "+ix+" - delete");
//                wssCreated.add(bld.save());
//            }
//            catch (GNDBException e)
//            {
//                e.printStackTrace();
//            }
//        }
    }

//    @AfterAll
//    void tearDown()
//    {
//        for (var aff : wssCreated)
//        {
//            try
//            {
//                CropRotationGroupBuilder bld = new CropRotationGroupBuilder(aff);
//                bld.delete();
//            }
//            catch (GNDBException e)
//            {
//                e.printStackTrace();
//            }
//        }
//    }

    @BeforeEach
    void eachTest()
    {
        myTest = new CropRotationGroupLister();
        wss = new ArrayList<>();
    }

    @Test
    void fetch()
    {
        try
        {
            wss = myTest.fetch();
        } catch (GNDBException e)
        {
            e.printStackTrace();
        }
        assertTrue(wss.size() > 0);
    }

//    @Test
//    void id()
//    {
//        int testId = wssCreated.get(0).getKey();
//        myTest.id(testId);
//        try
//        {
//            wss = myTest.fetch();
//        } catch (GNDBException e)
//        {
//            e.printStackTrace();
//        }
//        assertEquals(1, wss.size());
//        assertEquals(testId, wss.get(0).getKey());
//    }
//
//    @Test
//    void multiId()
//    {
//        int testId = wssCreated.get(0).getKey();
//        int testId2 = wssCreated.get(1).getKey();
//        int testId3 = wssCreated.get(2).getKey();
//        myTest.id(testId);
//        myTest.id(testId2, testId3);
//        try
//        {
//            wss = myTest.fetch();
//        } catch (GNDBException e)
//        {
//            e.printStackTrace();
//        }
//        assertEquals(3, wss.size());
//        assertEquals(testId, wss.get(0).getKey());
//        assertEquals(testId2, wss.get(1).getKey());
//        assertEquals(testId3, wss.get(2).getKey());
//    }
//
//    @Test
//    void name()
//    {
//        String testName = wssCreated.get(0).getName();
//        myTest.name(testName);
//        try
//        {
//            wss = myTest.fetch();
//        } catch (GNDBException e)
//        {
//            e.printStackTrace();
//        }
//        assertEquals(1, wss.size());
//        assertEquals(testName, wss.get(0).getName());
//    }
//
//    @Test
//    void multiName()
//    {
//        String testName = wssCreated.get(1).getName();
//        String testName2 = wssCreated.get(0).getName();
//        myTest.name(testName);
//        myTest.name(testName2); //  NB sequence, they should be sorted by name
//        try
//        {
//            wss = myTest.fetch();
//        } catch (GNDBException e)
//        {
//            e.printStackTrace();
//        }
//        assertEquals(2, wss.size(), "should be 2 entries");
//        assertEquals(testName2, wss.get(0).getName());
//        assertEquals(testName, wss.get(1).getName());
//    }
//
//    @Test
//    void multiNameBadName()
//    {
//        String testName = wssCreated.get(1).getName();
//        myTest.name("nonesuch");
//        myTest.name(testName);
//        try
//        {
//            wss = myTest.fetch();
//        } catch (GNDBException e)
//        {
//            e.printStackTrace();
//        }
//        assertEquals(1, wss.size(), "should be 1 entry");
//        assertEquals(testName, wss.get(0).getName());
//    }

    @Test
    void badName()
    {
        myTest.name("nonesuch");
        try
        {
            wss = myTest.fetch();
        } catch (GNDBException e)
        {
            e.printStackTrace();
        }
        assertEquals(0, wss.size());
    }

//    @Test
//    void cropRotationGroup()
//    {
//        myTest.cropRotationGroup(wssCreated.get(0));
//        try
//        {
//            wss = myTest.fetch();
//        } catch (GNDBException e)
//        {
//            e.printStackTrace();
//        }
//        assertEquals(1, wss.size());
//        assertEquals(wssCreated.get(0).getName(), wss.get(0).getName());
//        assertEquals(wssCreated.get(0).getKey(), wss.get(0).getKey());
//    }

//    @Test
//    void afflictionCLassMulti()
//    {
//        myTest.cropRotationGroup(wssCreated.get(2));
//        myTest.cropRotationGroup(wssCreated.get(1), wssCreated.get(0));
//        try
//        {
//            wss = myTest.fetch();
//        } catch (GNDBException e)
//        {
//            e.printStackTrace();
//        }
//        assertEquals(3, wss.size());
//        assertEquals(wssCreated.get(0).getName(), wss.get(0).getName());
//        assertEquals(wssCreated.get(0).getKey(), wss.get(0).getKey());
//        assertEquals(wssCreated.get(1).getName(), wss.get(1).getName());
//        assertEquals(wssCreated.get(1).getKey(), wss.get(1).getKey());
//        assertEquals(wssCreated.get(2).getName(), wss.get(2).getName());
//        assertEquals(wssCreated.get(2).getKey(), wss.get(2).getKey());
//    }
//
//    @Test
//    void afflictionCLassList()
//    {
//        myTest.cropRotationGroup(List.of(wssCreated.get(0)));
//        try
//        {
//            wss = myTest.fetch();
//        } catch (GNDBException e)
//        {
//            e.printStackTrace();
//        }
//        assertEquals(1, wss.size());
//        assertEquals(wssCreated.get(0).getName(), wss.get(0).getName());
//        assertEquals(wssCreated.get(0).getKey(), wss.get(0).getKey());
//    }
//
//    @Test
//    void afflictionCLassListMulti()
//    {
//        myTest.cropRotationGroup(List.of(wssCreated.get(2)));
//        myTest.cropRotationGroup(List.of(wssCreated.get(1), wssCreated.get(0)));
//        try
//        {
//            wss = myTest.fetch();
//        } catch (GNDBException e)
//        {
//            e.printStackTrace();
//        }
//        assertEquals(3, wss.size());
//        assertEquals(wssCreated.get(0).getName(), wss.get(0).getName());
//        assertEquals(wssCreated.get(0).getKey(), wss.get(0).getKey());
//        assertEquals(wssCreated.get(1).getName(), wss.get(1).getName());
//        assertEquals(wssCreated.get(1).getKey(), wss.get(1).getKey());
//        assertEquals(wssCreated.get(2).getName(), wss.get(2).getName());
//        assertEquals(wssCreated.get(2).getKey(), wss.get(2).getKey());
//    }


}