/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	This file is NOT generated.
 */

package uk.co.gardennotebook.spi;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 *	The increment intervals for repeated reminders.<BR>
 * The internal codes are used as explicit strings in the database and are used
 * in the database procedure which increments the next date for a repeating
 * Reminder.
 * 
 * @author Andy Gegg
 * @version 1.1.0
 * @since 1.1.0
 */
public enum ReminderIntervalType {
	/**
	 * Repeat by days
	 */
	DAYS("D"),
	/**
	 * Repeat by weeks
	 */
	WEEKS("W"),
	/**
	 * Repeat by months
	 */
	MONTHS("M"),
	/**
	 * Repeat by years
	 */
	YEARS("Y");

	private final String code;

	private static final Map<String, ReminderIntervalType> stringToEnum = new HashMap<>();

	static {
		for (ReminderIntervalType t : values()) stringToEnum.put(t.code(), t);
	}
	
	private ReminderIntervalType(String code)
	{
		this.code = code;
	}

/**
*	Translate a string into the appropriate enum.
*
*	@param	code	the string representation of the enum
*
*	@return	the enum represented by the string
*/
	public static ReminderIntervalType fromString(String code)
	{
		if (code == null) return null;
		return stringToEnum.get(code);
	}

/**
*	Get the string value corresponding to an enum.
*
*	@return	the string representation of the enum
*/
	public String code()
	{
		return this.code;
	}

/**
 *	Get a translated name for the period, using the supplied ResourceBundle.
 *	The ResourceBundle must contain the following keys:<UL>
 * <LI>lbl.reminder.interval.days
 * <LI>lbl.reminder.interval.weeks
 * <LI>lbl.reminder.interval.months
 * <LI>lbl.reminder.interval.years
 * </UL>
 * 
 * @param resources	a ResourceBundle which must contain the appropriate translations.
 * 
 * @return the translated display name.
 */
	public String getDisplayName(ResourceBundle resources)
	{
		if (resources == null)
		{
			return name();
		}
		String displayVal = name();
		try 
		{
			displayVal = resources.getString("lbl.reminder.interval."+name().toLowerCase());
		}
		catch (MissingResourceException ex)
		{
			return name();
		}
		return displayVal;
	}
}
