/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	Do not edit this file, it is generated.
 */

package uk.co.gardennotebook.spi;

import java.util.List;

import java.time.*;

/**
A noteworthy weather event.
*/
public interface IWeatherLister
{
	/**
	*	Returns the Weather entries matching the given criteria.
	*	If no criteria have been specified all Weather entries will be returned.
	*	Criteria are applied additively (i.e. criterion AND criterion).
	*
	*	@return	A list of Weather entries matching previously specified criteria.
	*
	*	@throws	GNDBException	If the underlying persistence store (e.g. a database) throws an exception.
	*			The causal Exception can be retrieved via <code>getCause()</code>
	*/
	public List<IWeather> fetch() throws GNDBException;

	/**
	*	Select only these Weather entries
	*	May be called repeatedly to add to the list of Weather entries to be returned
	*
	*	@param items	the list of Weather entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IWeatherLister weather(IWeather... items);

	/**
	*	Select only these Weather entries
	*	May be called repeatedly to add to the list of Weather entries to be returned
	*
	*	@param items	the list of Weather entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IWeatherLister weather(List<IWeather> items);

	/**
	*	Select only those Weather entries which are for these WeatherCondition entries.
	*	May be called repeatedly to add to the list of WeatherCondition entries to be selected.
	*
	*	@param items	the list of WeatherCondition items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IWeatherLister weatherCondition(IWeatherCondition... items);

	/**
	*	Select only those Weather entries which are for these WeatherCondition entries.
	*	May be called repeatedly to add to the list of WeatherCondition entries to be selected
	*
	*	@param items	the list of WeatherCondition items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IWeatherLister weatherCondition(List<IWeatherCondition> items);

	/**
	*	Select only those Weather entries which are on or after this date
	*	A null value will be ignored
	*	If called repeatedly only the last value given will be used
	*	If this method is not called no earliest date will be used in selection
	*
	*	@param	date	the earliest date to match
	*	@return	this Lister
	*/
	public IWeatherLister fromDate(LocalDate date);
	/**
	*	Select only those Weather entries which are on or before this date
	*	A null value will be ignored
	*	If called repeatedly only the last value given will be used
	*	If this method is not called no latest date will be used in selection
	*
	*	@param	date	the latest date to match
	*	@return	this Lister
	*/
	public IWeatherLister toDate(LocalDate date);

}
