/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	Do not edit this file, it is generated.
 */

package uk.co.gardennotebook.spi;

import java.util.List;

import java.time.*;

/**
A particular variety of a plant species.<BR>  Note that the common name is NOT a unique value as different species may have varieties with the same name - e.g. Money Maker tomato AND aubergine.<BR>
Note the use of a Trigger to reflect changes to commonName into Product.
*/
public interface IPlantVarietyLister
{
	/**
	*	Returns the PlantVariety entries matching the given criteria.
	*	If no criteria have been specified all PlantVariety entries will be returned.
	*	Criteria are applied additively (i.e. criterion AND criterion).
	*
	*	@return	A list of PlantVariety entries matching previously specified criteria.
	*
	*	@throws	GNDBException	If the underlying persistence store (e.g. a database) throws an exception.
	*			The causal Exception can be retrieved via <code>getCause()</code>
	*/
	public List<IPlantVariety> fetch() throws GNDBException;

	/**
	*	Select only these PlantVariety entries
	*	May be called repeatedly to add to the list of PlantVariety entries to be returned
	*
	*	@param items	the list of PlantVariety entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IPlantVarietyLister plantVariety(IPlantVariety... items);

	/**
	*	Select only these PlantVariety entries
	*	May be called repeatedly to add to the list of PlantVariety entries to be returned
	*
	*	@param items	the list of PlantVariety entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IPlantVarietyLister plantVariety(List<IPlantVariety> items);

	/**
	*	Select only those PlantVariety entries which are for these PlantSpecies entries.
	*	May be called repeatedly to add to the list of PlantSpecies entries to be selected.
	*	If PlantSpecies and PlantVariety lists are BOTH supplied, PlantVariety entries matching either will be selected.
	*
	*	@param items	the list of PlantSpecies items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IPlantVarietyLister plantSpecies(IPlantSpecies... items);

	/**
	*	Select only those PlantVariety entries which are for these PlantSpecies entries.
	*	May be called repeatedly to add to the list of PlantSpecies entries to be selected
	*	If PlantSpecies and PlantVariety lists are BOTH supplied, PlantVariety entries matching either will be selected.
	*
	*	@param items	the list of PlantSpecies items.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IPlantVarietyLister plantSpecies(List<IPlantSpecies> items);

}
