/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	Do not edit this file, it is generated.
 */

package uk.co.gardennotebook.spi;

import java.beans.PropertyChangeListener;
import java.util.List;
import java.time.*;

import java.util.Optional;

/**
*	Detailed information about a plant often not required.
*
*	@author	Andy Gegg
*	@version	1.0
*	@since	1.0
*/
public interface IPlantDetails extends INotebookEntry
{
	/**
	*	the owning PlantSpecies
	*
	*	@return	the PlantSpecies
	*/
	public IPlantSpecies getPlantSpecies();

	/**
	*	the owning PlantVariety
	*
	*	@return	the PlantVariety
	*/
	public Optional<IPlantVariety> getPlantVariety();

	/**
	*	get the value of utility (if present)
	*
	*	@return	the value of utility
	*/
	public Optional<String> getUtility();

	/**
	*	get the value of hardiness (if present)
	*
	*	@return	the value of hardiness
	*/
	public Optional<String> getHardiness();

	/**
	*	get the value of lifeType (if present)
	*
	*	@return	the value of lifeType
	*/
	public Optional<String> getLifeType();

	/**
	*	get the value of plantType (if present)
	*
	*	@return	the value of plantType
	*/
	public Optional<String> getPlantType();

	/**
	*	get the value of lastUpdated
	*
	*	@return	the value of lastUpdated
	*/
	public LocalDateTime getLastUpdated();

	/**
	*	get the value of created
	*
	*	@return	the value of created
	*/
	public LocalDateTime getCreated();


	/**
	*	add a change listener to the PlantDetails
	*
	*	@param	propertyName	identifies the change being flagged.  One of:<UL>
	*			<LI>deleted	-	this object has been deleted from the database, oldValue is the deleted object
	*			<LI>replaced	-	this object has been replaced in the database, oldValue is the deleted object, newValue its replacement
	*			<LI>Comment	-	this comment has been added to or deleted from this PlantDetails, newValue is an added comment, oldValue is a deleted comment
	</UL>
	*	@param	listener	a PropertyChangeListener (may be a Lambda expression)
	*/
	public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener);

	/**
	*	remove a change listener from the PlantDetails
	*
	*	@param	propertyName	identifies the change being flagged.  One of:<UL>
	*			<LI>deleted	-	this object has been deleted from the database, oldValue is the deleted object
	*			<LI>replaced	-	this object has been replaced in the database, oldValue is the deleted object, newValue its replacement
	*			<LI>Comment	-	this comment has been added to or deleted from this PlantDetails, newValue is an added comment, oldValue is a deleted comment
	</UL>
	*	@param	listener	the listener to remove
	*/
	public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener);

	/**
	*	signal to all listeners that this PlantDetails has been deleted
	*
	*/
	public void flagDeleted();

	/**
	*	signal to all listeners that this PlantDetails has been replaced
	*
	*	@param	newValue	the replacement PlantDetails
	*/
	public void flagReplaced(IPlantDetails newValue);

}

