/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	Do not edit this file, it is generated.
 */

package uk.co.gardennotebook.spi;

import java.util.List;

/**
The various types of diary entry for the husbandry lifecycle.
*/
public interface IHusbandryClassLister
{
	/**
	*
	*	Returns the HusbandryClass entries matching the given criteria
	*	If no criteria have been specified all HusbandryClass entries will be returned
	*	Criteria are applied additively (i.e. criterion AND criterion)
	*
	*	@return	A list of HusbandryClass entries matching previously specified criteria
	*
	*	@throws	GNDBException	If the underlying persistence store (e.g. a database) throws an exception.
	*			The causal Exception can be retrieved via <code>getCause()</code>
	*/
	public List<IHusbandryClass> fetch() throws GNDBException;

	/**
	*
	*	Select only these HusbandryClass entries
	*	May be called repeatedly to add to the list of HusbandryClass entries to be returned
	*
	*	@param items	the list of HusbandryClass entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IHusbandryClassLister key(IHusbandryClass... items);
	/**
	*
	*	Select only these HusbandryClass entries
	*	May be called repeatedly to add to the list of HusbandryClass entries to be returned
	*
	*	@param items	the list of HusbandryClass entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IHusbandryClassLister key(List<IHusbandryClass> items);

	/**
	*
	*	Select only the HusbandryClass entries with these name values
	*	May be called repeatedly to add to the list of name entries to be selected
	*
	*	@param items	the list of name values.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IHusbandryClassLister name(String... items);

}
