/*
 * Copyright (C) 2018, 2021 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	Change log
    3.0.0	'key' selector renamed 'groundworkActivity' for consistency
 */

package uk.co.gardennotebook.spi;

import java.util.List;

/**
  *	A type of groundwork activity.
 *
 *	@author	Andy Gegg
 *	@version	3.0.0
 *	@since	1.0
*/
public interface IGroundworkActivityLister
{
	/**
	*
	*	Returns the GroundworkActivity entries matching the given criteria
	*	If no criteria have been specified all GroundworkActivity entries will be returned
	*	Criteria are applied additively (i.e. criterion AND criterion)
	*
	*	@return	A list of GroundworkActivity entries matching previously specified criteria
	*
	*	@throws	GNDBException	If the underlying persistence store (e.g. a database) throws an exception.
	*			The causal Exception can be retrieved via <code>getCause()</code>
	*/
	public List<IGroundworkActivity> fetch() throws GNDBException;

	/**
	*
	*	Select only these GroundworkActivity entries
	*	May be called repeatedly to add to the list of GroundworkActivity entries to be returned
	*
	*	@param items	the list of GroundworkActivity entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IGroundworkActivityLister groundworkActivity(IGroundworkActivity... items);
	/**
	*
	*	Select only these GroundworkActivity entries
	*	May be called repeatedly to add to the list of GroundworkActivity entries to be returned
	*
	*	@param items	the list of GroundworkActivity entries.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IGroundworkActivityLister groundworkActivity(List<IGroundworkActivity> items);

	/**
	*
	*	Select only the GroundworkActivity entries with these name values
	*	May be called repeatedly to add to the list of name entries to be selected
	*
	*	@param items	the list of name values.  A null value or empty list is a null-op
	*	@return	this Lister
	*/
	public IGroundworkActivityLister name(String... items);

}
