/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	Do not edit this file, it is generated.
 */

package uk.co.gardennotebook;

import uk.co.gardennotebook.spi.GNDBException;
import uk.co.gardennotebook.spi.GNDBRuntimeException;

import uk.co.gardennotebook.fxbean.PlantSpeciesBean;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.EntryMessage;
import org.apache.logging.log4j.Level;

/**
	*	A species of plant grown in the garden, for instance, 'tomato'.  A species will have zero or more varieties.<BR>
Note the use of a Trigger to reflect changes to commonName into Product.
	*
	*	Must be public to be loaded by FXML
	*
	*	@author	Andy Gegg
	*	@version	1.1.0
	*	@since	1.0
*/
final public class PlantSpeciesCombo extends DiaryEntryCombo<PlantSpeciesBean>
{
	private static final Logger LOGGER = LogManager.getLogger();

	public PlantSpeciesCombo()
	{
		super();
		try
		{
			this.getItems().setAll(PlantSpeciesBean.fetchAll());
		} catch (GNDBException ex) {
			PanicHandler.panic(ex);
		}
		super.currentValue = null;
	}

	public PlantSpeciesCombo(PlantSpeciesBean initialVal)
	{
		this();
		this.setValue(initialVal);
		super.currentValue = initialVal;
	}

	@Override
	String getName(PlantSpeciesBean item)
	{
		EntryMessage log4jEntryMsg = LOGGER.traceEntry("getName({})", item);
		if (item == null)
		{
			return "";
		}
		if (item instanceof PlantSpeciesBean)
		{
			return ((PlantSpeciesBean)item).getCommonName();
		}
		else
		{
			throw new UnsupportedOperationException("PlantSpeciesCombo: getName: unknown object in converter: "+item);
		}
	}	//	getName()

	@Override
	PlantSpeciesBean newItem(String name)
	{
		EntryMessage log4jEntryMsg = LOGGER.traceEntry("newItem({})", name);
		if (name == null || name.isEmpty())
		{
			return null;
		}
		PlantSpeciesBean added = new PlantSpeciesBean();
		added.setCommonName(name);
		try
		{
			added.save();
		} catch (GNDBException ex) {
			PanicHandler.panic(ex);
		}
		return LOGGER.traceExit(log4jEntryMsg,added);
	}	//	newItem()
}
