/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	This file, is NOT generated.
 */

package uk.co.gardennotebook;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.TreeItem;

/**
 *
	*	@author Andy Gegg
	*	@version	1.0
	*	@since	1.0
 */
final class PlantCatalogueCheckBoxTreeItem extends CheckBoxTreeItem<PlantCatalogueItem> {

	PlantCatalogueCheckBoxTreeItem(PlantCatalogueItem val){
		super(val);
	}
	
	PlantCatalogueCheckBoxTreeItem(){
		super();
	}
	
	boolean isFirstCall = true;
	
	@Override
	public ObservableList<TreeItem<PlantCatalogueItem>> getChildren()
	{
		if (isFirstCall)
		{
			isFirstCall = false;
			PlantCatalogueItem val = (PlantCatalogueItem) this.getValue();
			if (val == null) return FXCollections.emptyObservableList();
			ObservableList<PlantCatalogueCheckBoxTreeItem> kids = FXCollections.<PlantCatalogueCheckBoxTreeItem>observableArrayList();
			for (PlantCatalogueItem pc : val.getChildren())
				kids.add(new PlantCatalogueCheckBoxTreeItem(pc));
			super.getChildren().setAll(kids);
		}
		return super.getChildren();
	}

	@Override
	public boolean isLeaf() {
		return ((PlantCatalogueItem)(this.getValue())).isLeaf();
	}

}
