/*
 *
 *  Copyright (C) 2022 Andrew Gegg
 *
 * 	This file is part of the Gardeners Notebook application
 *
 *  The Gardeners Notebook application is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 *
 *
 */

package uk.co.gardennotebook;

import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.co.gardennotebook.fxbean.INotebookBean;

import java.util.Optional;
import java.util.ResourceBundle;

/**
 * A convenience class to handle Cancel edit requests in Editors
 *
 * @param resources the resource bundle containing the text of the confirmation question for the user
 *
 *	@author Andy Gegg
 *	@version	3.0.4
 *	@since	3.0.4
 */
record NotebookEditorCanceller<T extends INotebookBean>(ResourceBundle resources)
{
    private static final Logger LOGGER = LogManager.getLogger();

    /**
     * Checks with the user if the Cancel action is required
     *
     * @param ixBean the Bean being edited
     *
     * @return true if Cancel is denied (user wishes to continue editing).
     */
    boolean isCancelDenied(T ixBean)
    {
        if (ixBean.needSave())
        {
            return checkCancelDenied();
        }
        return false;
    }

    private boolean checkCancelDenied()
    {
        Alert checkQuit = new Alert(Alert.AlertType.CONFIRMATION, resources.getString("alert.confirmquit"), ButtonType.NO, ButtonType.YES);
        Optional<ButtonType> result = checkQuit.showAndWait();
        LOGGER.debug("after delete dialog: result:{}, result.get:{}", result, result.orElse(null));
        if (result.isPresent() && result.get() == ButtonType.YES)
        {
            LOGGER.debug("after quit allowed");
            return false;
        }

        return true;
    }

}

