/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
    Change Log
	2.2.1   Show direcory for hsqldb
 */

package uk.co.gardennotebook;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * Displays various options to configure the Application.
 * In particular, the log-in options for database managers can be set here.
 * 
 * This class should be used to populate a pop-up or initial window.
 *
 * @author Andrew Gegg
*	@version	1.1.1
*	@since	1.0
 */
final class NotebookAbout extends AnchorPane
{	
	private static final Logger LOGGER = LogManager.getLogger();

//	@FXML
//	Tab mysqlTab;
	@FXML
	TextArea txtLicence;

    @FXML
    Label lblNotebookVersion;
    
    @FXML
    GridPane dbDetails;
    @FXML
    Label dbActiveRDBMS;
    @FXML
    Label dbVersion;
    @FXML
    Label dbHostLbl;
    @FXML
    Label dbHost;
    @FXML
    Label dbPortLbl;
    @FXML
    Label dbPort;
    @FXML
    Label dbDirectoryLbl;
    @FXML
    Label dbDirectory;
    @FXML
    Label dbUser;
    @FXML
    Label dbDatabase;
    @FXML
    Label dbSchemaLbl;
    @FXML
    Label dbSchema;
    
	@FXML
	private ResourceBundle resources;

	Preferences prefs = Preferences.userNodeForPackage(GardenNotebook.class);
	boolean firstTime = prefs.getBoolean("firstTime", true);

	boolean calledAsLogin = false;

	/**
	 * Basic information about the Garden Notebook application.
	 * In particular, it displays a copy of the GNU GPL
	 * 
	 */
	NotebookAbout()
	{
		FXMLLoader fxmlLoader = new FXMLLoader(getClass().getResource("/fxml/NotebookAbout.fxml"),
			ResourceBundle.getBundle("notebook") );
		fxmlLoader.setRoot(this);
		fxmlLoader.setController(this);
		try {
			fxmlLoader.load();	// NB initialize is called from in here
		} catch (IOException exception) {
			throw new RuntimeException(exception);
		}
	}
	

	/*
	 * Initializes the controller class.
	 */
	@FXML
	public void initialize()
	{
        lblNotebookVersion.setText("Version " + GardenNotebook.NOTEBOOK_VERSION);
		StringBuilder licText = new StringBuilder();
		InputStream ips1bis = GardenNotebook.class.getResourceAsStream("/gpl.txt");
		LOGGER.debug("ips1bis: {}", ips1bis);
		try (	Reader licRead = new InputStreamReader(ips1bis);
				BufferedReader licBuff = new BufferedReader(licRead);
			)
		{	
			while (licBuff.ready())
			{
				licText.append(licBuff.readLine()).append("\n");
			}
		} catch (FileNotFoundException ex) {
			Platform.runLater(() -> PanicHandler.panic(ex));
		} catch (IOException ex) {
			Platform.runLater(() -> PanicHandler.panic(ex));
		}
		txtLicence.setText(licText.toString());

        dbDetails.setVisible(false);
        if ("SQL".equalsIgnoreCase(prefs.get("selectedTrug", "")))
        {
            dbDetails.setVisible(true);
            Preferences pt = prefs.node("SQL");
            dbActiveRDBMS.setText(pt.get("selectedServer", "unknown"));
            Preferences ps = pt.node(pt.get("selectedServer", "unknown"));
            dbVersion.setText(ps.get("dbversion", "unknown"));
            
            dbHost.setText(ps.get("host", "unknown"));
            dbPort.setText(ps.get("port", "unknown"));
            
            dbUser.setText(ps.get("user", "unknown"));
            
            dbDatabase.setText(ps.get("database", "unknown"));
            switch (pt.get("selectedServer", "unknown"))
            {
                case "MSSQLServer", "MySQL", "MariaDB" -> {
                    dbHostLbl.setVisible(true);
                    dbHost.setVisible(true);
                    dbPortLbl.setVisible(true);
                    dbPort.setVisible(true);
                    dbDirectoryLbl.setVisible(false);
                    dbDirectory.setVisible(false);
                    dbSchemaLbl.setVisible(false);
                    dbSchema.setVisible(false);
                }
                case "PostgreSQL" -> {
                    dbHostLbl.setVisible(true);
                    dbHost.setVisible(true);
                    dbPortLbl.setVisible(true);
                    dbPort.setVisible(true);
                    dbDirectoryLbl.setVisible(false);
                    dbDirectory.setVisible(false);
                    dbSchemaLbl.setVisible(true);
                    dbSchema.setVisible(true);
                    dbSchema.setText(ps.get("schema", "unknown"));
                }
                case "hsqldb" -> {
                    dbHostLbl.setVisible(false);
                    dbHost.setVisible(false);
                    dbPortLbl.setVisible(false);
                    dbPort.setVisible(false);
                    dbDirectoryLbl.setVisible(true);
                    dbDirectory.setVisible(true);
                    dbDirectory.setText(ps.get("directory", "unknown"));
                    dbSchemaLbl.setVisible(false);
                    dbSchema.setVisible(false);
                }
                default -> {
                    dbHostLbl.setVisible(true);
                    dbHost.setVisible(true);
                    dbPortLbl.setVisible(true);
                    dbPort.setVisible(true);
                    dbDirectoryLbl.setVisible(false);
                    dbDirectory.setVisible(false);
                    dbSchemaLbl.setVisible(true);
                    dbSchema.setVisible(true);
                    dbSchema.setText(ps.get("schema", "unknown"));
                }
            }
        }
		
	}	

	@FXML
	private void btnCloseOnAction(ActionEvent event)
	{
		this.getScene().getWindow().hide();
	}


	
}
