/*
 * Copyright (C) 2018 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	WARNING
	Do not edit this file, it is generated.
 */

package uk.co.gardennotebook;

import uk.co.gardennotebook.spi.GNDBException;
import uk.co.gardennotebook.spi.GNDBRuntimeException;

import uk.co.gardennotebook.fxbean.GroundworkActivityBean;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.EntryMessage;
import org.apache.logging.log4j.Level;

/**
	*	A type of groundwork activity.
	*
	*	Must be public to be loaded by FXML
	*
	*	@author	Andy Gegg
	*	@version	1.1.0
	*	@since	1.0
*/
final public class GroundworkActivityCombo extends DiaryEntryCombo<GroundworkActivityBean>
{
	private static final Logger LOGGER = LogManager.getLogger();

	public GroundworkActivityCombo()
	{
		super();
		try
		{
			this.getItems().setAll(GroundworkActivityBean.fetchAll());
		} catch (GNDBException ex) {
			PanicHandler.panic(ex);
		}
		super.currentValue = null;
	}

	public GroundworkActivityCombo(GroundworkActivityBean initialVal)
	{
		this();
		this.setValue(initialVal);
		super.currentValue = initialVal;
	}

	@Override
	String getName(GroundworkActivityBean item)
	{
		EntryMessage log4jEntryMsg = LOGGER.traceEntry("getName({})", item);
		if (item == null)
		{
			return "";
		}
		if (item instanceof GroundworkActivityBean)
		{
			return ((GroundworkActivityBean)item).getName();
		}
		else
		{
			throw new UnsupportedOperationException("GroundworkActivityCombo: getName: unknown object in converter: "+item);
		}
	}	//	getName()

	@Override
	GroundworkActivityBean newItem(String name)
	{
		EntryMessage log4jEntryMsg = LOGGER.traceEntry("newItem({})", name);
		if (name == null || name.isEmpty())
		{
			return null;
		}
		GroundworkActivityBean added = new GroundworkActivityBean();
		added.setName(name);
		try
		{
			added.save();
		} catch (GNDBException ex) {
			PanicHandler.panic(ex);
		}
		return LOGGER.traceExit(log4jEntryMsg,added);
	}	//	newItem()
}
