/*
 * Copyright (C) 2019 Andrew Gegg
 *
 *	This file is part of the Gardeners Notebook application
 *
 * The Gardeners Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

package uk.co.gardennotebook;

import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import uk.co.gardennotebook.fxbean.CommentBean;

/**
	*	Support updatable comments in item editors
	*
	*	@author Andy Gegg
	*	@version	2.4.0
	*	@since	2.4.0
 */
public class EditorCommentTextTableCell extends TableCell<CommentBean, String>
{
	private final ResourceBundle resources;
	
	EditorCommentTextTableCell(ResourceBundle resources)
	{
		this.resources = resources;
	}
	
    @Override
    protected void updateItem(String item, boolean empty)
    {
        super.updateItem(item, empty);
		if (item == null || empty)
		{
			setText(null);
			setGraphic(null);
			return;
		}
        updateViewMode();
    }			

    @Override
    public void startEdit()
    {
        super.startEdit();
        updateViewMode();
    }

    @Override
    public void cancelEdit()
    {
        super.cancelEdit();
        updateViewMode();
    }

    private void updateViewMode()
    {
        // protect against empty rows at end of displayed table
        if (getItem() == null) return;

        setGraphic(null);
        setText(null);
        if (isEditing())
        {
            VBox vBox = new VBox();
            TextField dp = new TextField();
            dp.setPromptText(resources.getString("comment.text.prompt"));
            if (getItem() != null && !getItem().isEmpty()) dp.setText(getItem());
            dp.setOnAction(ev -> commitEdit(dp.getText()) );
//            dp.setOnAction(ev -> {
//                System.out.println("EditorCommentTextTableCell: onAction event");commitEdit(dp.getText()); } );
            //  if user tabs out after editing, make sure the TextField updates
            dp.focusedProperty().addListener((obj, wasFocused, isFocused)->{
                if (wasFocused && !isFocused)
                {
                    dp.fireEvent(new ActionEvent());
                }
            });
            vBox.getChildren().add(dp);
            setGraphic(vBox);
            dp.requestFocus();
        }
        else if (getItem() != null)
        {
            setText(getItem());
        }

    }
}

