/*
 *
 *  Copyright (C) 2022 Andrew Gegg
 *
 * 	This file is part of the Gardeners Notebook application
 *
 *  The Gardeners Notebook application is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 *
 *
 */

package uk.co.gardennotebook;

import javafx.scene.shape.SVGPath;

/**
 *  Contains the icons to be used on Diary entries.
 *  This class is not instantiable, use <code>SVGPath x = DiaryIcons.whatever</code>
 *
 *	@author Andy Gegg
 *	@version	3.0.1
 *	@since	3.0.1
 */
final class DiaryIcons
{
    static final SVGPath weatherGraphic = new SVGPath();
    static final SVGPath husbandryGraphic = new SVGPath();
    static final SVGPath afflictionGraphic = new SVGPath();
    static final SVGPath purchaseGraphic = new SVGPath();
    static final SVGPath saleGraphic = new SVGPath();
    static final SVGPath groundworkGraphic = new SVGPath();
    static final SVGPath wildlifeGraphic = new SVGPath();
    static final SVGPath journalGraphic = new SVGPath();

    //  The icons are initialised here not in a constructor because the constructor is only executed when an instance is created.
    static {
        afflictionGraphic.setContent("""
					M406.31,236.147l-24-48c-0.726-1.452-1.902-2.628-3.354-3.354l-32-16c-1.779-0.89-3.838-1.036-5.726-0.407l-19.337,6.446
					c-1.38-6.02-2.9-12.002-4.579-17.888c-6.508-22.818-14.698-41.646-24.396-56.169c0.547-0.551,1.025-1.188,1.391-1.92l16-32
					c0.521-1.042,0.792-2.189,0.792-3.354V33.923c0-3.071-0.9-6.044-2.604-8.598L293.843,3.341c-2.297-3.447-6.955-4.378-10.4-2.08
					c-3.447,2.297-4.378,6.954-2.08,10.4l14.656,21.985c0.055,0.083,0.084,0.178,0.084,0.277v5.583c0,11.491-6.894,21.674-17.563,25.942
					l-15.856,6.343c-9.551-5.164-19.93-7.79-31.08-7.79s-21.53,2.626-31.08,7.79l-15.857-6.343
					c-10.669-4.268-17.563-14.451-17.563-25.948v-5.578c0-0.099,0.029-0.195,0.084-0.278l14.656-21.984
					c2.298-3.446,1.367-8.103-2.08-10.4c-3.446-2.297-8.103-1.367-10.4,2.08l-14.656,21.984c-1.703,2.555-2.604,5.528-2.604,8.599
					v29.578c0,1.165,0.271,2.312,0.792,3.354l16,32c0.366,0.733,0.844,1.369,1.391,1.92c-9.698,14.523-17.888,33.351-24.396,56.168
					c-1.679,5.886-3.199,11.867-4.579,17.888l-19.337-6.446c-1.887-0.629-3.946-0.483-5.726,0.407l-32,16
					c-1.452,0.726-2.628,1.902-3.354,3.354l-24,48c-1.853,3.705-0.351,8.21,3.354,10.062c1.077,0.539,2.221,0.793,3.348,0.793
					c2.751,0,5.4-1.52,6.714-4.147l22.882-45.764l26.985-13.493l18.032,6.01c-3.383,17.676-5.652,35.303-7.166,51.506l-21.813,7.271
					c-1.75,0.583-3.225,1.792-4.14,3.394l-32,56c-0.508,0.89-0.829,1.875-0.942,2.893l-8,72c-0.458,4.117,2.509,7.825,6.626,8.282
					c0.281,0.031,0.561,0.046,0.837,0.046c3.771,0,7.019-2.837,7.445-6.672l7.829-70.456l29.808-52.163l13.036-4.345
					c-1.35,19.639-1.626,36.042-1.626,46.136c0,74.123,48.944,126.099,78.119,150.484c7.354,6.147,16.366,9.22,25.381,9.22
					c9.013,0,18.028-3.074,25.381-9.22c29.175-24.385,78.119-76.362,78.119-150.484c0-10.095-0.277-26.497-1.626-46.136l13.036,4.345
					l29.808,52.163l7.829,70.456c0.426,3.836,3.674,6.673,7.445,6.672c0.276,0,0.556-0.015,0.837-0.046
					c4.117-0.458,7.083-4.166,6.626-8.282l-8-72c-0.113-1.019-0.434-2.003-0.942-2.893l-32-56c-0.916-1.602-2.39-2.811-4.14-3.394
					l-21.813-7.271c-1.514-16.203-3.782-33.83-7.166-51.506l18.032-6.01l26.985,13.493l22.882,45.764
					c1.314,2.628,3.962,4.148,6.714,4.147c1.127,0,2.271-0.255,3.348-0.793C406.662,244.357,408.163,239.851,406.31,236.147z
					 M231.595,246.816c-10.249-6.263-40.906-26.934-66.255-63.816h132.522C272.569,219.77,241.851,240.528,231.595,246.816z
					 M168.513,136.765c4.877,2.446,9.918,3.672,14.946,3.671c8.906-0.001,17.767-3.811,25.573-11.332
					c1.388-1.337,3.43-2.104,5.604-2.104h33.935c2.173,0,4.216,0.767,5.603,2.103c12.215,11.767,27.003,14.444,40.521,7.665
					c2.95,7.396,5.685,15.486,8.196,24.289c0.656,2.298,1.277,4.617,1.885,6.943h-65.672v-8.5c0-4.142-3.358-7.5-7.5-7.5
					s-7.5,3.358-7.5,7.5v8.5H158.43c0.607-2.326,1.229-4.645,1.885-6.943C162.826,152.254,165.562,144.162,168.513,136.765z
					 M189.496,100.057l9.124,18.249c-7.835,7.546-15.888,9.118-23.978,4.74C179.173,113.997,184.125,106.326,189.496,100.057z
					 M288.563,123.046c-8.09,4.379-16.143,2.807-23.978-4.74l9.124-18.248C279.08,106.326,284.032,113.997,288.563,123.046z
					 M284.11,79.375c1.421-0.568,2.794-1.209,4.125-1.909l-5.26,10.52c-1.892-2.076-3.829-4.023-5.814-5.831L284.11,79.375z
					 M262.313,89.311l-11.402,22.804c-0.772-0.074-1.552-0.114-2.341-0.114h-33.935c-0.788,0-1.569,0.041-2.341,0.114l-11.402-22.804
					c9.248-6.851,19.491-10.31,30.71-10.31S253.065,82.46,262.313,89.311z M179.095,79.375l6.95,2.78
					c-1.985,1.808-3.922,3.755-5.814,5.831l-5.26-10.52C176.301,78.166,177.674,78.807,179.095,79.375z M153.086,191.667
					c27.214,39.592,59.781,61.396,71.016,68.168v47.721c-18.109,12.957-32.988,32.651-41.156,54.646
					c-4.829,13.003-7.005,25.963-6.559,38.265c-18.08-24.984-33.285-57.677-33.285-96.967
					C143.102,283.35,144.224,237.471,153.086,191.667z M247.363,442.476c-9.132,7.634-22.39,7.634-31.521,0
					c-5.43-4.538-11.596-10.1-17.986-16.634c-8.378-16.578-8.698-37.277-0.848-58.419c6.961-18.745,19.431-35.518,34.594-46.761
					c15.163,11.243,27.633,28.016,34.594,46.761c7.85,21.142,7.53,41.841-0.848,58.419C258.959,432.376,252.793,437.938,247.363,442.476
					z M286.817,400.467c0.446-12.302-1.731-25.262-6.559-38.265c-8.167-21.995-23.047-41.689-41.156-54.646v-47.721
					c11.235-6.772,43.802-28.576,71.016-68.168c8.862,45.804,9.984,91.684,9.984,111.834
					C320.102,342.791,304.897,375.483,286.817,400.467z""");

        groundworkGraphic.setContent("""
					M192.253,169.951c-0.579,0-1.165-0.028-1.744-0.082c-4.901-0.461-9.329-2.804-12.468-6.595
					c-3.139-3.791-4.614-8.579-4.152-13.479c0.896-9.522,8.776-16.703,18.331-16.703c0.579,0,1.165,0.028,1.743,0.082
					c4.901,0.461,9.329,2.803,12.469,6.594c3.14,3.792,4.615,8.579,4.154,13.48C209.688,162.77,201.807,169.951,192.253,169.951z
					 M183.845,150.731c-0.258,2.237,0.463,4.431,1.899,6.165c1.436,1.734,3.461,2.806,5.703,3.017c4.703,0.448,8.747-2.98,9.182-7.602
					c0.211-2.241-0.463-4.431-1.899-6.165c-1.436-1.734-3.467-2.753-5.704-3.017C190.924,142.882,184.674,143.535,183.845,150.731z
					M376.792,393.866c-8.657-87.771-47.74-153.947-79.002-194.007c-32.966-42.243-63.604-64.57-66.457-66.607
					c-2.74-2.285-5.354-4.311-7.861-6.134c-0.932-11.848-4.513-69.618,9.212-120.823c0.493-1.84-0.102-3.8-1.535-5.055
					c-1.432-1.255-3.453-1.587-5.213-0.857c-0.751,0.312-18.604,7.861-35.836,26.631c-14.913,16.245-31.933,44.144-31.45,86.423
					c-3.594-2.259-6.815-5.199-9.693-8.858c-22.312-28.364-14.555-88.026-14.475-88.625c0.179-1.321-0.178-2.66-0.989-3.717
					c-3.55-4.62-7.571-6.904-11.907-6.796c-6.269,0.16-9.961,3.902-11.123,7.317c-22.729,66.806,16.073,139.956,16.744,141.391
					c-10.604,5.787-13.7,20.591-13.003,28.783c-1.713,34.117-13.727,96.89-61.059,202.616c-1.083,2.421-12.245,25.516,4.354,36.169
					c0.816,0.524,1.754,0.747,2.696,0.747c0.884,0,1.786-0.219,2.648-0.659c7.049-3.596,35.564-46.75,56.35-82.932
					c15.989-27.832,34.517-63.332,44.887-94.294c1.531,0.388,3.37,0.815,5.49,1.235l-1.679,6.409c-0.7,2.671,0.899,5.404,3.57,6.104
					c0.425,0.111,0.851,0.164,1.27,0.164c2.218,0,4.245-1.488,4.833-3.734l1.942-7.416c3.082,0.339,6.42,0.58,9.941,0.657l0.23,7.938
					c0.079,2.711,2.301,4.855,4.995,4.855c0.049,0,0.099,0,0.148-0.002c2.76-0.08,4.933-2.383,4.853-5.143l-0.23-7.905
					c2.918-0.218,5.908-0.571,8.941-1.092l1.841,7.966c0.534,2.312,2.592,3.875,4.867,3.875c0.373,0,0.752-0.042,1.13-0.129
					c2.691-0.622,4.368-3.307,3.746-5.997l-1.841-7.968c3.469-1.023,6.948-2.303,10.396-3.879l4.119,6.822
					c0.939,1.556,2.591,2.417,4.285,2.417c0.88,0,1.771-0.233,2.58-0.721c2.364-1.427,3.123-4.501,1.696-6.865l-3.874-6.416
					c2.374-1.501,4.709-3.188,6.997-5.043c30.511,32.825,49.87,66.169,61.369,90.451c12.68,26.776,18.302,47.529,20.008,54.583
					c-5.039,5.429-7.88,12.585-7.88,20.063c0,16.263,13.23,29.494,29.493,29.494c16.263,0,29.493-13.231,29.493-29.494
					C376.814,395.809,376.859,394.541,376.792,393.866z M197.171,34.1c8.311-9.125,16.886-15.419,23.155-19.338
					c-9.465,42.721-8.453,86.368-7.354,105.542c-19.568-8.297-32.176-7.509-40.18-1.737c-1.391-0.21-2.736-0.49-4.048-0.827
					C167.337,84.494,176.891,56.368,197.171,34.1z M111.571,332.064c-22.5,39.378-44.378,70.896-51.682,79.138
					c-4.82-4.972,1.334-19.22,2.385-21.568c48.127-107.503,60.246-171.668,61.937-206.564c0.01-0.208-0.473-15.263,7.361-19.933
					c12.84,25.418,26.009,43.311,30.157,48.713C158.742,238.005,141.007,280.547,111.571,332.064z M134.233,145.476
					c-14.725-32.898-29.135-81.855-14.527-128.775c0.553-1.055,1.389-1.244,2.136-1.263c0.636-0.041,2.12,0.464,2.458,1.441
					c-1.313,11.81-5.77,65.171,16.787,93.869c6.018,7.656,13.464,12.937,22.208,15.804c-8.893,9.014-8.618,18.475-8.592,18.745
					l3.449,35.994c0.097,1.015,0.502,1.975,1.161,2.753c7.814,9.232,18.479,14.793,28.818,18.144l-19.027,2.826
					C163.874,198.079,147.704,175.573,134.233,145.476z M232.15,227.169l-3.584-5.935c-1.428-2.364-4.502-3.123-6.865-1.696
					c-2.364,1.427-3.123,4.501-1.696,6.865l3.27,5.416c-2.461,1.058-4.943,1.955-7.427,2.701l-1.382-5.983
					c-0.621-2.69-3.308-4.371-5.997-3.746c-2.691,0.622-4.368,3.307-3.746,5.997l1.377,5.962c-2.348,0.382-4.67,0.653-6.948,0.835
					l-0.186-6.384c-0.08-2.761-2.396-4.933-5.143-4.853c-2.76,0.08-4.933,2.383-4.853,5.143l0.185,6.358
					c-2.462-0.061-4.823-0.208-7.051-0.414l1.659-6.334c0.7-2.671-0.899-5.404-3.57-6.104c-2.673-0.702-5.405,0.898-6.104,3.57
					l-1.96,7.483c-1.951-0.363-3.643-0.734-5.063-1.073c2.034-7.118,3.55-13.911,4.384-20.202l49.142-7.299
					c5.919,5.264,11.504,10.605,16.792,15.978C235.673,224.801,233.928,226.049,232.15,227.169z M347.321,415.303
					c-10.748,0-19.493-8.745-19.493-19.494c0-5.622,2.429-10.972,6.665-14.677l-0.009-0.01c1.301-1.14,1.988-2.908,1.626-4.726
					c-0.201-1.008-5.109-25.082-21.219-59.187c-14.83-31.396-42.383-77.489-89.429-118.779c-0.96-0.843-2.197-1.285-3.484-1.239
					c-0.367,0.013-36.091,1.102-54.026-18.465l-3.244-33.857c0.259-1.743,1.908-9.46,11.184-16.308
					c16.345-11.957,49.395,12.663,49.507,12.741c0.312,0.22,31.528,22.447,64.508,64.71c30.448,39.017,68.512,103.451,76.934,188.836
					C366.873,395.18,363.435,415.303,347.321,415.303z""");

        husbandryGraphic.setContent("""
					M168.738,78.689c-6.199-11.366-22.006-15.919-30.417-18.148
					c6.428-7.329,19.362-22.715,16.466-36.272c-1.378-6.413-6.023-11.459-13.804-14.995c-0.705-0.322-2.97-1.557-5.043-2.684
					c-6.936-3.769-10.067-5.397-11.481-5.748c-4.105-1.02-8.052-1.117-11.61-0.268c-14.434,3.4-20.013,20.79-22.726,29.429
					c-6.31-5.186-18.589-14.981-30.596-14.981c-1.575,0-3.11,0.172-4.563,0.515c-5.601,1.317-10.214,5.089-13.736,11.213
					c-0.14,0.254-0.744,1.26-1.553,2.602l-0.19,0.315c-3.837,6.352-5.601,9.319-5.952,10.078c-3.686,8.128-4.098,15.5-1.213,21.899
					c5.35,11.875,20.371,16.917,28.473,19.415c-5.851,7.158-17.382,22.021-14.251,35.316c1.557,6.571,6.399,11.717,14.412,15.31
					c0.469,0.211,2.892,1.578,4.846,2.677l0.419,0.236c6.098,3.45,8.292,4.645,9.276,4.96c5.071,1.6,9.91,1.897,14.244,0.877
					c12.776-3.01,18.764-16.921,21.405-24.082c7.347,12.834,20.131,43.243,5.712,82.092l-0.34,0.898l6.399,2.369l0.329-0.902
					c13.374-36.032,4.613-65.582-2.96-81.591c7.816,4.688,14.888,7.057,21.079,7.057c1.743,0,3.439-0.19,5.043-0.565
					c6.807-1.603,12.122-6.506,15.786-14.57c0.211-0.469,2.154-3.847,2.881-5.132c3.343-5.823,4.499-7.909,4.785-8.775
					C172.074,90.352,171.709,84.118,168.738,78.689z M164.2,95.302c-0.258,0.651-2.799,5.107-4.173,7.505l-0.132,0.233
					c-1.872,3.264-2.859,4.996-3.149,5.633c-2.859,6.292-6.803,10.064-11.717,11.22c-1.177,0.272-2.434,0.419-3.74,0.419
					c-10.873,0-23.209-9.513-27.972-13.217l-0.748-0.859l-0.179,0.14l-3.228-2.512l-2.831,8.239
					c-2.122,5.97-7.079,19.956-17.969,22.525c-3.267,0.773-7.047,0.508-11.012-0.744c-0.709-0.258-5.451-2.928-8.192-4.484
					c-3.099-1.75-5.032-2.834-5.751-3.16c-6.238-2.791-9.946-6.567-11.041-11.234c-2.609-11.08,9.359-25.671,13.872-31.165
					c0.966-1.192,1.675-2.047,2.083-2.656l2.015-3.049l-3.389-1.364c-0.755-0.308-1.882-0.659-3.318-1.099
					c-6.936-2.119-21.369-6.531-25.864-16.488c-2.144-4.767-1.743-10.475,1.206-16.957c0.329-0.684,3.987-6.753,5.63-9.484
					c0.948-1.564,1.664-2.759,1.814-3.031c2.663-4.624,6.002-7.44,9.917-8.367c1.027-0.24,2.112-0.361,3.25-0.361
					c10.207,0,22.225,9.899,27.367,14.129c1.335,1.102,2.301,1.9,3.01,2.373l3.021,1.99l1.385-3.328
					c0.408-0.977,0.837-2.33,1.385-4.083c2.512-8.045,7.193-23.026,18.467-25.682c2.641-0.619,5.651-0.53,8.793,0.243
					c0.956,0.258,7.176,3.636,9.835,5.078l0.24,0.132c2.82,1.528,4.581,2.48,5.422,2.867c5.97,2.716,9.488,6.349,10.436,10.812
					c2.401,11.216-10.425,25.778-16.008,32.117c-1.177,1.335-1.954,2.212-2.373,2.842l-2.072,3.078l3.45,1.364
					c0.82,0.326,2.04,0.651,3.865,1.134c7.297,1.922,22.475,5.923,27.697,15.5C165.675,85.539,165.897,90.051,164.2,95.302z
					M100.822,52.459c-1.396,0-2.799,0.165-4.166,0.487c-9.738,2.298-15.797,12.089-13.503,21.827
					c1.943,8.231,9.208,13.983,17.662,13.983h0.007c1.385,0,2.792-0.161,4.159-0.487c4.713-1.109,8.711-3.99,11.259-8.12
					c2.562-4.126,3.35-8.997,2.244-13.707C116.544,58.21,109.276,52.459,100.822,52.459z M110.6,76.659
					c-1.625,2.616-4.155,4.445-7.147,5.15c-0.866,0.204-1.754,0.304-2.641,0.304c-5.365,0-9.967-3.647-11.191-8.865
					c-1.457-6.177,2.384-12.383,8.561-13.839c0.866-0.204,1.754-0.308,2.641-0.308c5.365,0,9.967,3.647,11.191,8.865
					C112.726,70.955,112.217,74.04,110.6,76.659z""");

        journalGraphic.setContent("""
									M197.523,251.759h-27.152v-28.415h12.917c11.565,0,20.974-9.409,20.974-20.974v-26.467
									c0-11.565-9.409-20.974-20.974-20.974H69.673c-11.565,0-20.974,9.409-20.974,20.974v26.467c0,11.565,9.409,20.974,20.974,20.974
									H82.59v28.415H55.438c-6.943,0-13.561,2.985-18.156,8.191c-4.595,5.205-6.736,12.141-5.875,19.03l10.97,87.763
									c1.511,12.094,11.842,21.213,24.03,21.213h120.145c12.188,0,22.519-9.12,24.03-21.213l10.97-87.763
									c0.861-6.889-1.28-13.826-5.875-19.031C211.083,254.745,204.466,251.759,197.523,251.759z M69.673,203.344
									c-0.537,0-0.974-0.437-0.974-0.974v-26.467c0-0.537,0.437-0.974,0.974-0.974h113.614c0.537,0,0.974,0.437,0.974,0.974v26.467
									c0,0.537-0.437,0.974-0.974,0.974h-12.917H82.59H69.673z M102.59,223.344h47.781v28.415H102.59V223.344z M201.708,276.5
									l-10.97,87.763c-0.263,2.106-2.062,3.694-4.185,3.694H66.408c-2.123,0-3.921-1.588-4.185-3.694l-10.97-87.763
									c-0.206-1.642,0.553-2.781,1.022-3.313c0.471-0.533,1.507-1.426,3.162-1.426H82.59h87.781h27.152c1.655,0,2.691,0.894,3.162,1.426
									S201.913,274.857,201.708,276.5z
									M343.645,49.951C331.412,8.666,315.033,0,303.447,0s-27.965,8.666-40.198,49.951
									c-8.442,28.491-13.091,66.189-13.091,106.149s4.649,77.658,13.091,106.149c9.008,30.402,20.263,43.105,30.198,47.695v68.012h20
									v-68.012c9.935-4.59,21.19-17.293,30.198-47.695c8.442-28.491,13.091-66.189,13.091-106.149S352.086,78.442,343.645,49.951z
									 M324.468,256.568c-3.595,12.134-7.475,20.675-11.021,26.35V129.044h-20v153.874c-3.547-5.675-7.427-14.217-11.022-26.351
									c-7.911-26.698-12.267-62.378-12.267-100.468s4.356-73.77,12.267-100.468C290.171,29.489,299.24,20,303.447,20
									c4.206,0,13.275,9.489,21.021,35.632c7.911,26.698,12.267,62.378,12.267,100.468C336.735,194.19,332.379,229.87,324.468,256.568z""");

        purchaseGraphic.setContent("""
					M27.931,6.281c-0.47-0.472-1.395-0.457-1.395-0.457H7.648L7.024,3.221c-0.223-0.933-1.059-1.593-2.02-1.593H0l0.969,2.079
					l3.052-0.01c0.693-0.002,1.292,0.485,1.433,1.165l2.783,13.395c0.326,1.572,1.71,2.702,3.315,2.702c3.995,0,11.053,0,12.259,0
					c1.697,0,1.802-1.87,1.802-1.87s-9.963,0-13.512,0c-0.698,0-1.514,0.097-2.032-1.915c-0.192-0.745-0.641-3.006-0.641-3.006
					l16.921-0.022c0.744-0.026,1.377-0.589,1.462-1.352l0.578-5.264C28.44,7.046,28.403,6.75,27.931,6.281z M25.935,12.038H8.975
					L8.155,8.21h18.196L25.935,12.038z""");

        saleGraphic.setContent("""
									M133.565,278.261h-22.261c-3.073,0-5.565,2.492-5.565,5.565v22.261c0,3.073,2.492,5.565,5.565,5.565h22.261
									c3.073,0,5.565-2.492,5.565-5.565v-22.261C139.13,280.753,136.638,278.261,133.565,278.261z
									M200.348,278.261h-22.261c-3.073,0-5.565,2.492-5.565,5.565v22.261c0,3.073,2.492,5.565,5.565,5.565h22.261
									c3.073,0,5.565-2.492,5.565-5.565v-22.261C205.913,280.753,203.421,278.261,200.348,278.261z
									M267.13,278.261H244.87c-3.073,0-5.565,2.492-5.565,5.565v22.261c0,3.073,2.492,5.565,5.565,5.565h22.261
									c3.073,0,5.565-2.492,5.565-5.565v-22.261C272.696,280.753,270.204,278.261,267.13,278.261z
									M333.913,278.261h-22.261c-3.073,0-5.565,2.492-5.565,5.565v22.261c0,3.073,2.492,5.565,5.565,5.565h22.261
									c3.073,0,5.565-2.492,5.565-5.565v-22.261C339.478,280.753,336.986,278.261,333.913,278.261z
									M400.696,278.261h-22.261c-3.073,0-5.565,2.492-5.565,5.565v22.261c0,3.073,2.492,5.565,5.565,5.565h22.261
									c3.073,0,5.565-2.492,5.565-5.565v-22.261C406.261,280.753,403.769,278.261,400.696,278.261z
									M133.565,345.043h-22.261c-3.073,0-5.565,2.492-5.565,5.565v22.261c0,3.073,2.492,5.565,5.565,5.565h22.261
									c3.073,0,5.565-2.492,5.565-5.565v-22.261C139.13,347.536,136.638,345.043,133.565,345.043z
									M200.348,345.043h-22.261c-3.073,0-5.565,2.492-5.565,5.565v22.261c0,3.073,2.492,5.565,5.565,5.565h22.261
									c3.073,0,5.565-2.492,5.565-5.565v-22.261C205.913,347.536,203.421,345.043,200.348,345.043z
									M267.13,345.043H244.87c-3.073,0-5.565,2.492-5.565,5.565v22.261c0,3.073,2.492,5.565,5.565,5.565h22.261
									c3.073,0,5.565-2.492,5.565-5.565v-22.261C272.696,347.536,270.204,345.043,267.13,345.043z
									M333.913,345.043h-22.261c-3.073,0-5.565,2.492-5.565,5.565v22.261c0,3.073,2.492,5.565,5.565,5.565h22.261
									c3.073,0,5.565-2.492,5.565-5.565v-22.261C339.478,347.536,336.986,345.043,333.913,345.043z
									M400.696,345.043h-22.261c-3.073,0-5.565,2.492-5.565,5.565v22.261c0,3.073,2.492,5.565,5.565,5.565h22.261
									c3.073,0,5.565-2.492,5.565-5.565v-22.261C406.261,347.536,403.769,345.043,400.696,345.043z
									M484.174,411.826h-5.565v-116.87c0-40.313-28.725-74.042-66.783-81.799v-62.897c0-9.22-7.475-16.696-16.696-16.696
									H217.043v-33.391h66.783c9.22,0,16.696-7.475,16.696-16.696V16.696c0-9.22-7.475-16.696-16.696-16.696H116.87
									c-9.22,0-16.696,7.475-16.696,16.696v66.783c0,9.22,7.475,16.696,16.696,16.696h66.783v33.391H116.87
									c-9.22,0-16.696,7.475-16.696,16.696v62.897c-38.057,7.757-66.783,41.485-66.783,81.799v116.87h-5.565
									C12.483,411.826,0,424.309,0,439.652v44.522C0,499.517,12.483,512,27.826,512h456.348C499.517,512,512,499.517,512,484.174
									v-44.522C512,424.309,499.517,411.826,484.174,411.826z M133.565,66.783V33.391H267.13v33.391H133.565z M133.565,166.957h244.87
									v44.522h-244.87V166.957z M66.783,294.957c0-27.618,22.469-50.087,50.087-50.087H395.13c27.618,0,50.087,22.469,50.087,50.087
									v116.87H66.783V294.957z M478.609,478.609H33.391v-33.391c11.558,0,433.753,0,445.217,0V478.609z""");

        weatherGraphic.setContent("""
							M28.848,16.29c-0.111-0.415-0.53-0.663-0.958-0.552l-6.583,1.763l-2.28-1.316l2.789-2.717
							c0.212-0.207,0.288-0.519,0.196-0.801s-0.335-0.488-0.63-0.531l-1.113-0.163l1.036-0.598l6.584,1.764
							c0.067,0.018,0.137,0.026,0.202,0.026c0.346,0,0.662-0.23,0.756-0.58c0.11-0.417-0.137-0.844-0.553-0.956l-5.076-1.359l2.74-1.583
							c0.374-0.216,0.502-0.694,0.286-1.066c-0.216-0.374-0.691-0.504-1.067-0.286L22.44,8.915l1.36-5.073
							c0.11-0.417-0.138-0.846-0.553-0.957c-0.422-0.111-0.846,0.137-0.957,0.552l-1.764,6.583l-2.754,1.59l-0.708-0.103L15.218,7.76
							V6.954l4.819-4.818c0.305-0.305,0.305-0.8,0-1.105c-0.306-0.305-0.801-0.305-1.106,0l-3.714,3.713V1.583
							c0-0.431-0.35-0.781-0.781-0.781c-0.432,0-0.781,0.35-0.781,0.781v3.165L9.939,1.032c-0.304-0.304-0.799-0.305-1.105,0
							c-0.305,0.304-0.305,0.8,0,1.105l4.82,4.821v0.799l-1.85,3.751l-0.704,0.102l-2.755-1.591L6.583,3.437
							c-0.11-0.416-0.53-0.664-0.957-0.553C5.21,2.995,4.961,3.424,5.074,3.84l1.358,5.074L3.695,7.333
							C3.321,7.116,2.843,7.245,2.628,7.618C2.413,7.992,2.541,8.469,2.914,8.685l2.741,1.583l-5.076,1.359
							c-0.416,0.112-0.665,0.541-0.552,0.956c0.094,0.349,0.41,0.58,0.755,0.58c0.065,0,0.134-0.008,0.202-0.026l6.585-1.763l1.035,0.598
							L7.49,12.134c-0.295,0.043-0.54,0.249-0.63,0.531c-0.093,0.282-0.016,0.594,0.197,0.801l2.79,2.72l-2.28,1.317l-6.581-1.765
							c-0.421-0.111-0.846,0.136-0.958,0.552s0.135,0.846,0.553,0.957l5.071,1.36l-2.737,1.581c-0.373,0.216-0.501,0.693-0.286,1.067
							c0.145,0.251,0.408,0.391,0.677,0.391c0.132,0,0.267-0.034,0.39-0.104l2.741-1.583l-1.361,5.075
							c-0.111,0.416,0.135,0.845,0.552,0.957c0.068,0.018,0.136,0.026,0.202,0.026c0.346,0,0.662-0.23,0.755-0.58l1.766-6.586
							l1.583-0.913L9.441,20.81c-0.05,0.293,0.07,0.588,0.312,0.763c0.238,0.175,0.56,0.197,0.822,0.059l3.081-1.619v1.902l-4.82,4.82
							c-0.305,0.306-0.305,0.801,0,1.106c0.305,0.305,0.8,0.305,1.105,0l3.715-3.717v3.165c0,0.432,0.35,0.781,0.781,0.781
							c0.431,0,0.781-0.35,0.781-0.781V24.13l3.713,3.714c0.153,0.151,0.353,0.229,0.553,0.229s0.399-0.075,0.553-0.229
							c0.305-0.306,0.305-0.801,0-1.106l-4.819-4.817v-1.904l3.078,1.617c0.113,0.062,0.238,0.091,0.363,0.091
							c0.162,0,0.325-0.05,0.459-0.149c0.24-0.175,0.361-0.47,0.312-0.763l-0.493-2.873l1.587,0.915l1.765,6.584
							c0.094,0.35,0.409,0.58,0.755,0.58c0.065,0,0.134-0.009,0.202-0.026c0.416-0.112,0.664-0.541,0.552-0.957l-1.36-5.075l2.739,1.583
							c0.123,0.069,0.258,0.104,0.39,0.104c0.271,0,0.533-0.14,0.678-0.391c0.216-0.374,0.087-0.852-0.286-1.067l-2.737-1.58l5.074-1.359
							C28.711,17.136,28.958,16.708,28.848,16.29z M14.798,18.03c-0.112-0.06-0.238-0.09-0.364-0.09c-0.125,0-0.25,0.03-0.363,0.09
							l-2.823,1.483l0.539-3.144c0.043-0.253-0.041-0.511-0.225-0.692l-2.283-2.225l3.156-0.458c0.255-0.037,0.475-0.197,0.588-0.427
							l1.41-2.86l1.411,2.86c0.114,0.23,0.334,0.391,0.589,0.427l3.154,0.458l-2.281,2.225c-0.185,0.18-0.269,0.438-0.225,0.692
							l0.538,3.144L14.798,18.03z""");

        wildlifeGraphic.setContent("""
					M351.945,78.127c0-15.715-12.785-28.5-28.5-28.5s-28.5,12.785-28.5,28.5s12.785,28.5,28.5,28.5
					S351.945,93.842,351.945,78.127z M323.445,86.627c-4.687,0-8.5-3.813-8.5-8.5s3.813-8.5,8.5-8.5s8.5,3.813,8.5,8.5
					S328.132,86.627,323.445,86.627z
					M418.793,44.984c-1.861-5.2-7.586-7.905-12.786-6.042l-10.469,3.749C382.314,17.354,355.761,0,325.433,0
					c-0.211,0-0.424,0.001-0.635,0.002c-28.26,0.232-54.416,15.711-68.26,40.398c-15.471,27.58-32.914,51.936-51.846,72.389
					C148.867,173.092,68.993,257.436,66.238,260.344l-54.92,55.768c-6.843,6.942-7.62,17.3-1.89,25.187
					c5.731,7.886,15.822,10.349,24.537,5.985c35.455-17.72,77.226-19.256,114.606-4.212c18.526,7.456,38.012,11.621,58.021,12.433
					l20.874,62.641c1.396,4.191,5.299,6.841,9.486,6.841c1.047,0,2.114-0.166,3.162-0.516c5.24-1.746,8.072-7.409,6.326-12.648
					l-18.893-56.697c5.313-0.412,10.579-1.064,15.785-1.949l21.651,64.969c1.396,4.19,5.299,6.841,9.486,6.841
					c1.048,0,2.113-0.166,3.162-0.516c5.24-1.746,8.072-7.409,6.326-12.649l-21.048-63.16c27.994-8.187,53.671-23.389,74.897-44.743
					c33.171-33.371,51.283-77.511,51.001-124.292c-0.102-15.604-2.251-31.018-6.398-45.91c14.413-15.004,22.375-35.102,22.026-56.085
					c-0.094-5.551-0.779-10.96-1.973-16.178l10.285-3.684C417.95,55.908,420.655,50.184,418.793,44.984z M384.442,77.968
					c0.287,17.303-6.992,33.803-19.973,45.27c-2.968,2.622-4.108,6.749-2.909,10.523c4.71,14.82,7.149,30.295,7.251,45.991
					c0.25,41.412-15.797,80.502-45.186,110.068c-7.557,7.603-15.753,14.32-24.459,20.115c-4.381-13.661-6.606-27.898-6.606-42.473
					c0-30.697,9.801-59.795,28.344-84.149c3.346-4.394,2.496-10.668-1.898-14.014c-4.396-3.347-10.67-2.495-14.014,1.898
					c-21.217,27.866-32.432,61.154-32.432,96.265c0,18.106,3.003,35.765,8.919,52.624c-20.836,10.187-43.83,15.576-67.629,15.576
					c-19.987,0-39.438-3.749-57.812-11.144c-19.451-7.828-39.949-11.72-60.345-11.72c-23.459,0-46.781,5.152-68.194,15.386
					l53.056-53.876c0.045-0.046,0.09-0.092,0.135-0.139c0.813-0.859,82.074-86.649,138.679-147.794
					c19.999-21.606,38.373-47.24,54.612-76.192c10.344-18.444,29.878-30.009,50.979-30.182c21.891-0.176,41.204,11.756,51.532,29.511
					l-2.987,1.07c-5.199,1.862-7.904,7.587-6.042,12.786c1.463,4.085,5.311,6.631,9.414,6.631c1.119,0,2.258-0.189,3.372-0.588
					l3.204-1.148C384.039,71.42,384.385,74.659,384.442,77.968z
					M257.13,174.243c-0.009,0-0.017,0-0.025,0c-5.511,0-9.985,4.461-9.999,9.976c-0.001,0.365-0.005,0.729-0.01,1.086
					c-0.339,22.138-9.196,43.061-24.938,58.914c-15.743,15.853-36.603,24.853-58.735,25.342c-8.946,0.196-17.647-0.942-26.018-3.397
					l83.582-92.036c3.713-4.089,3.408-10.413-0.681-14.126c-4.088-3.713-10.413-3.409-14.126,0.68l-93.384,102.829
					c-2.123,2.339-3.018,5.543-2.41,8.644c0.606,3.1,2.643,5.732,5.491,7.097c14.313,6.86,29.625,10.331,45.553,10.331
					c0.81,0,1.621-0.009,2.434-0.027c27.334-0.604,53.076-11.7,72.485-31.245c19.407-19.543,30.326-45.362,30.745-72.709
					c0.007-0.446,0.011-0.891,0.012-1.335C267.119,178.744,262.652,174.256,257.13,174.243z
					M336.89,139.683c-3.255,2.417-6.46,4.992-9.525,7.654c-4.17,3.621-4.615,9.937-0.993,14.107
					c1.977,2.277,4.758,3.443,7.554,3.443c2.325,0,4.66-0.806,6.553-2.45c2.683-2.33,5.487-4.583,8.334-6.697
					c4.435-3.292,5.36-9.556,2.068-13.99C347.587,137.317,341.324,136.391,336.89,139.683z""");

    }

    private DiaryIcons() { }

}
