/*
 * Copyright (C) 2019, 2021, 2023 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
	Change log
    3.0.0   First version.
    3.1.0   Fixing the bug in CommentCellImpl meant that the comments tried to bind to the non-existent CroppingPlanBean for
            a Year node.  So, added a pretend bean and made sure the cell is not editable.
 */

package uk.co.gardennotebook;

import javafx.scene.control.TreeTableCell;
import uk.co.gardennotebook.spi.NotebookEntryType;

import java.util.ResourceBundle;

/**
 *
	*	@author	Andy Gegg
	*	@version	3.1.0
	*	@since	3.0.0
 */
final class CroppingPlanTreeCommentCell extends TreeTableCell<CroppingPlanTreeBean, CroppingPlanTreeBean> {

    private final CommentCellImpl trueCell;
    private double cellHeight;

    CroppingPlanTreeCommentCell(ResourceBundle resources) {
    trueCell = new CommentCellImpl(resources);
}

    @Override
    protected void updateItem(CroppingPlanTreeBean item, boolean empty) {
        super.updateItem(item, empty);
        if (item == null || empty) {
            setText(null);
            setGraphic(null);
            return;
        }

        if (item.getNodeType() == NotebookEntryType.UNKNOWN)
            setEditable(false);

        cellHeight = this.getHeight();
        trueCell.setParent(item.getItem());	//	2.9.6
        trueCell.updateViewMode(this, item.getComments());
    }

    @Override
    public void startEdit() {
        super.startEdit();
        cellHeight = this.getHeight();
        trueCell.setParent(getItem().getItem());
        trueCell.updateViewMode(this, getItem().getComments());
    }

    @Override
    public void cancelEdit() {
        super.cancelEdit();
        trueCell.updateViewMode(this, getItem().getComments());
        this.setPrefHeight(cellHeight);
    }
    
}
