/*
 * Copyright (C) 2021 Andrew Gegg
 *
 *	This file is part of the Garden Notebook application
 *
 * The Garden Notebook application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/gpl.html>.
 */

/*
	Change log
	3.0.0	First version
 */

package uk.co.gardennotebook;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.EntryMessage;
import uk.co.gardennotebook.fxbean.CropRotationGroupBean;
import uk.co.gardennotebook.spi.GNDBException;

/**
 *	The crop rotation groups as used to avoid disease build up, etc.
	*
	*	Must be public to be loaded by FXML
	*
	*	@author	Andy Gegg
	*	@version	3.0.0
	*	@since	3.0.0
*/
final public class CropRotationGroupCombo extends DiaryEntryCombo<CropRotationGroupBean>
{
	private static final Logger LOGGER = LogManager.getLogger();

	public CropRotationGroupCombo()
	{
		super();
		try
		{
			this.getItems().setAll(CropRotationGroupBean.fetchAll());
		} catch (GNDBException ex) {
			PanicHandler.panic(ex);
		}
		super.currentValue = null;
	}

	public CropRotationGroupCombo(CropRotationGroupBean initialVal)
	{
		this();
		this.setValue(initialVal);
		super.currentValue = initialVal;
	}

	@Override
	String getName(CropRotationGroupBean item)
	{
		EntryMessage log4jEntryMsg = LOGGER.traceEntry("getName({})", item);
		if (item == null)
		{
			return "";
		}
		return item.getName();
	}	//	getName()

	@Override
	CropRotationGroupBean newItem(String name)
	{
		EntryMessage log4jEntryMsg = LOGGER.traceEntry("newItem({})", name);
		if (name == null || name.isEmpty())
		{
			return null;
		}
		CropRotationGroupBean added = new CropRotationGroupBean();
		added.setName(name);
		try
		{
			added.save();
		} catch (GNDBException ex) {
			PanicHandler.panic(ex);
		}
		return LOGGER.traceExit(log4jEntryMsg,added);
	}	//	newItem()
}
