@echo OFF
rem build the database and populate with standard data

setlocal
setlocal enabledelayedexpansion

set directory=%APPDATA%\GardenNotebook\hsqldb
set database=gardennotebook
set user=SA

set doload=Y

:startloop
if "%1"=="" goto endloop
if "%1"=="/?" goto help
if "%1"=="/n" set doload=N& shift
if "%1"=="/d" set directory=%2 & shift & shift
if "%1"=="/b" set database=%2 & shift & shift
if "%1"=="/u" echo "only user SA allowed" & shift & shift
if "%1"=="/w" echo "no password may be given" & shift & shift
goto startloop

:endloop
rem if "%password%"=="" (set /p password=Enter password:)

rem if "%password%"=="" goto myexit

for /l %%a in (1,1,31) do if "!directory:~-1!"==" " set directory=!directory:~0,-1!
for /l %%a in (1,1,31) do if "!database:~-1!"==" " set database=!database:~0,-1!
for /l %%a in (1,1,31) do if "!user:~-1!"==" " set user=!user:~0,-1!

echo directory "%directory%"
echo database "%database%"
echo user "%user%"
echo password %password%

set /p confirm=Are these values OK? (Y/N)
if /I not "%confirm%"=="Y" goto myexit

rem goto myexit

java -jar ..\bin\sqltool.jar --inlineRc=url=jdbc:hsqldb:file:%directory%/%database%,user=%user%,password= GardenNotebook_HSQL_3_0_0.sql >install_log_create.txt


if "%doload%"=="N" (goto myexit)

java -jar ..\bin\sqltool.jar --inlineRc=url=jdbc:hsqldb:file:%directory%/%database%,user=%user%,password=%password% DB_inserts_HSQL.sql >install_log_system.txt

java -jar ..\bin\sqltool.jar --inlineRc=url=jdbc:hsqldb:file:%directory%/%database%,user=%user%,password= DB_inserts_HSQL_local.sql >install_log_user.txt


goto myexit

:help
echo Build the Garden Notebook database for embedded use and populate with basic data
echo DB_Builder [/?] [/u username] [/w password] [/d directory] [/b database] [/n]
echo - /? show this help and exit
echo - /u the username to use (default is SA).  User must have SUPER privilege.
echo - /w the password to use (not required if user is SA)
echo - /d the directory (folder) where the datafiles will be stored
echo - /b the name of the database, default "gardennotebook"
echo - /n do NOT insert basic data.  Use this if restoring, e.g. from a JSON dump


:myexit
rem set directory=
rem set database=
rem set user=
rem set password=
rem set doload=

endlocal