USE gardennotebook;
GO

-- ---------
-- Data for PlantSpecies
-- ---------
BEGIN TRANSACTION;
SET IDENTITY_INSERT plantspecies ON;
GO

INSERT INTO plantspecies (plantSpeciesId, cropRotationGroupId, commonName, latinName, utility, hardiness, lifeType) VALUES
    (1, 3, 'tomato', 'Lycopersicon esculentum', 'vegetable', 'tender', 'annual'),
    (2, 3, 'aubergine', 'Solanum melongena', 'vegetable', 'tender', 'annual'),
    (3, 1, 'broad bean', 'Vicia faba', 'vegetable', 'hardy', 'annual'),
    (4, 1, 'french bean', 'Phaseolus vulgaris', 'vegetable', 'tender', 'annual'),
    (5, 1, 'runner bean', 'Phaseolus coccineus', 'vegetable', 'tender', 'treat as annual'),
    (6, 4, 'beetroot', 'Beta vulgaris subsp vulgaris', 'vegetable', default, 'annual'),
    (7, 6, 'courgette', 'Cucurbita pepo', 'vegetable', 'tender', 'annual'),
    (8, 6, 'cucumber', 'Cucumis sativus', 'salad', 'tender', 'annual'),
    (9, 5, 'garlic', 'Allium sativum', 'vegetable', 'hardy', 'annual'),
    (10, 5, 'leek', 'Allium porrum', 'vegetable', 'hardy', 'annual'),
    (11, 5, 'onion', 'Allium cepa', 'vegetable', 'hardy', 'annual'),
    (12, 6, 'lettuce', 'Lactuca sativa', 'salad', 'tender', 'annual'),
    (13, 4, 'parsnip', 'Pastinaca sativa', 'vegetable', 'hardy', 'annual'),
    (14, 1, 'pea', 'Pisum sativum', 'vegetable', default, 'annual'),
    (15, 3, 'potato', 'Solanum tuberosum', 'vegetable', default, 'perennial'),
    (16, 2, 'radish', 'Raphanus sativus', 'salad', 'tender', 'annual'),
    (17, 2, 'cabbage', 'Brassica oleracea', 'vegetable', 'hardy', 'annual');
SET IDENTITY_INSERT plantspecies OFF;
    
-- ---------
-- Data for PlantVariety
-- some varieties of tomato, aubergine, runner bean, courgette and potato
-- ---------
INSERT INTO plantvariety (plantSpeciesId, commonName, description) VALUES
    (1, 'gardeners delight', 'A reliable salad tomato with good flavour and good yield'),
    (1, 'ailsa craig', 'A good slicing tomato for salad or cooking'),
    (1, 'moneymaker', DEFAULT),
    (2, 'moneymaker', 'A reliable aubergine with small fruit but a good yield'),
    (5, 'scarlet emperor', 'Most popular variety, reliable, good yield and good flavour'),
    (7, 'parthenon', 'Parthenocarpic variety, does not need fertilising.  Green fruit.  Very reliable in UK gardens, heavy cropper of dense fruit with good flavour'),
    (7, 'gold mine', 'Parthenocarpic variety, does not need fertilising.  Yellow fruit.  Very reliable in UK gardens, good crop of dense fruit with good flavour'),
    (15, 'king edward', 'Traditional main crop with good flavour'),
    (15, 'charlotte', 'Second early variety.  Waxy texture.  Usually grown as a salad potato but also good roasted or baked');
    
-- ---------
-- Data for PlantNote
-- ---------
INSERT INTO plantnote (plantspeciesid, title, note) values (2, 'Cultivation',
'Aubergines need plenty of light and warmth - they originated in India.  They are best grown undercover, an upright lean-to grow cabinet at the side of the house is quite adequate.  Aubergines need a long growing season so seed needs to be sown late January to February - St Valentine''s Day is a good target.  Sow seeds just covering them with compost and place in a propagator at 20C; keep at same temperature after germination.  Prick out when when first true leaves have developed.  Grow steadily with consistent warmth and moisture through March to May; pot on as the roots fill the pot.  Overwatering can lead to poor root development and young plants can be sensitive to too much sun.  Plant out in a greenhouse border in early May, 60cm (2'') between plants; they are greedy feeders so add plenty of well-rotted compost.  Support is essential.  Alternatively use a 30cm (12") pot.  Keep soil moist but not saturated with a consistent watering regime.  Once fruit has set, feed weekly with a high potash fertiliser.  Harvest fruits when firm and glossy (they should rebound from a gentle squeeze) using secateurs; left too long the fruits dull and become very seedy and bitter.  There is no need to train the plants nor to cut out side shoots but it''s worth pinching out the growing tip when the plant reaches 30cm (12").  If space is limited train plants into two vertical stems after pinching out.  Mist with tepid water and ensure a gentle breeze in the greenhouse to help pollination.  Aubergines are prone to red spider mite attack - damp down, mist and use biological controls.');

COMMIT;
GO
