
-- -----------------------------------------------------
-- Data for table `GroundworkActivity`
-- -----------------------------------------------------
-- START TRANSACTION;
INSERT INTO groundworkactivity (name, description) VALUES 
	('pruning', NULL),
	('spraying', NULL),
	('manuring', NULL),
	('weeding', NULL),
	('clearing', NULL),
	('digging', NULL),
	('plant support', 'Erecting any form of plant support'),
	('mulching', NULL),
	('greenhouse', 'Any work on a greenhouse, e.g. cleaning'),
	('pest control', 'Any activity concerned with pest control'),
	('compost', NULL),
	('liming', 'Applying garden lime to the soil to reduce acidity'),
	('mowing', NULL),
	('hedge trimming', NULL),
	('cloche', NULL),
	('watering', NULL),
	('soil conditioning', 'Applying any form of soil treatment, specifically chemical (e.g. potash)'),
	('scarify', 'Rake out the ''thatch'' in a lawn'),
	('aerate', 'Make (many) small holes in a lawn to improve drainage'),
	('feeding', 'Any activity to feed established plants'),
	('strimming', 'Use of strimmer, e.g. to tidy round edge of lawn');

COMMIT;


-- -----------------------------------------------------
-- Data for table `CropRotationGroup`
-- -----------------------------------------------------
INSERT INTO croprotationgroup (cropRotationGroupId, name, subsequentCropGroupId, description) overriding system value VALUES
	(6, 'Fillers', null, 'Crops less susceptible to disease build up'),
	(5, 'Alliums', null, 'Garlic, leeks, onions, shallots'),
	(4, 'Root vegetables', 5, 'Beetroot, carrot, celeriac, celery, parsley, parsnip, etc'),
	(3, 'Potatoes', 4, 'Potatoes and closely related species such as tomatoes and aubergines'),
	(2, 'Brassicas', 3, 'Brussels sprouts, cabbage, cauliflower, kale, oriental greens, kohl-rabi, radish, swede, turnips'),
	(1, 'Legumes', 2, 'Peas and all beans');

UPDATE croprotationgroup SET subsequentCropGroupId = 1 WHERE cropRotationGroupId = 5;

COMMIT;

-- -----------------------------------------------------
-- Data for table `Location`
-- -----------------------------------------------------
-- START TRANSACTION;

INSERT INTO location (locationId, parentLocationId, name, description, underCover, geometry, lastUpdated, created) overriding system value VALUES
	(1, NULL, 'The Garden', '', DEFAULT, 'POLYGON((0 0, 0 100, 100 100, 100 0, 0 0))', DEFAULT, DEFAULT);

COMMIT;


-- -----------------------------------------------------
-- Data for table `ProductCategory`
-- -----------------------------------------------------
-- START TRANSACTION;
INSERT INTO productcategory (name, description, plantLike) VALUES
	('potted plants', NULL, 'TRUE'),
	('sundries', 'anything not covered elsewhere', 'FALSE'),
	('tubers', 'tubers, bulbs, corms, etc', 'TRUE'),
	('seed', NULL, 'TRUE'),
	('planting media', 'compost, etc', 'FALSE'),
	('plug plants', 'also plants in strips', 'TRUE'),
	('fertilisers', 'Growmore, manure, compost accelerators', 'FALSE'),
	('pest control', 'animal, fungal, etc', 'FALSE'),
	('tools', NULL, 'FALSE'),
	('labour', NULL, 'FALSE'),
	('bare root plants', NULL, 'TRUE'),
	('root ball plants', 'plants supplied in a root ball', 'TRUE');

COMMIT;


-- -----------------------------------------------------
-- Data for table `HusbandryClass`
-- -----------------------------------------------------
-- START TRANSACTION;
INSERT INTO husbandryclass (name, description, terminal) VALUES 
	('sow', 'when seeds are sown', DEFAULT),
	('pot up', 'when seedlings are transferred to their first pot', DEFAULT),
	('pot on', 'when a plant is repotted in a larger pot', DEFAULT),
	('germination', 'when seeds are seen to germinate, usually use ''emergence''', DEFAULT),
	('emergence', 'when seedlings first appear above ground', DEFAULT),
	('plant out', 'when plants are moved to their final position', DEFAULT),
	('harden off', 'the hardening off process for new plants', DEFAULT),
	('flowering', 'when a plant flowers', DEFAULT),
	('fruiting', 'when a plant sets fruit', DEFAULT),
	('harvest', 'when a crop is taken from a plant', DEFAULT),
	('bud break', 'leaf or flower bud', DEFAULT),
	('observation', 'an observation on the progress of a crop', DEFAULT),
	('chit', 'usually for potatoes, when a tuber is brought into growth before planting', DEFAULT),
	('failure', 'when one or more plants fails to thrive or grow', TRUE),
	('abandoned', 'when one or more plants are discarded, possibly due to failure or being surplus', TRUE),
	('earth up', 'usually for potatoes', DEFAULT),
	('thin out', 'reducing fruit load on a plant or reducing overcrowding of plants', DEFAULT),
	('transplant', NULL, DEFAULT),
	('prune', 'removing excess growth from a plant, usually fruit trees', DEFAULT),
	('prick out', 'when seedlings are transferred to their first pot (see pot up)', DEFAULT),
	('repot', 'when a potted plant is moved to a new pot', DEFAULT),
	('discarded', 'when plants are discarded as unwanted (e.g. excess sown)', TRUE),
	('death', 'to record the death of a plant for whatever reason', TRUE),
	('heel in', 'when a new plant, usually bare-root, cannot be properly planted, loosely plant it in a convenient bed or pot', FALSE),
	('collect seed', 'collect the seed either to eat (e.g. fennel) or to sow for a new crop (e.g. tomatoes)', FALSE),
	('take cutting', 'make a cutting of some sort for propagation', FALSE),
	('cut back', 'reduce the size of a plant for any of a variety of reasons', FALSE),
	('pinch out', 'remove the growing tip from a young plant to encourage bushy growth', FALSE);

COMMIT;


-- -----------------------------------------------------
-- Data for table `AfflictionClass`
-- -----------------------------------------------------
-- START TRANSACTION;
INSERT INTO afflictionclass (name, description) VALUES 
	('pest', 'any insect or animal which harms the crop'),
	('disease', 'any pathogen of the plant, fungal, viral, etc'),
	('death', 'any cause of death');

COMMIT;

