echo OFF
rem build the database and populate with standard data

setlocal

set port=3306
set host=localhost
set user=root
set rdbmstype=MySQL

set doload=Y

:startloop

if "%1"=="" goto endloop
if "%1"=="/?" goto help
if "%1"=="/D" set rdbmstype=%2& shift & shift
if "%1"=="/n" set doload=N& shift
if "%1"=="/p" set port=%2 & shift & shift
if "%1"=="/h" set host=%2 & shift & shift
if "%1"=="/u" set user=%2 & shift & shift
if "%1"=="/w" set password=%2 & shift & shift

goto startloop

:endloop
if "%password%"=="" (set /p password=Enter password:)

if "%password%"=="" goto myexit

echo DB Manager %rdbmstype%
echo port %port%
echo host %host%
echo user %user%
echo password %password%

set /p confirm=Are these values OK? (Y/N)
if /I not "%confirm%"=="Y" goto myexit

rem goto myexit

if /i "%rdbmstype%"=="SQLServer" goto sqlserver

mysql -u%user% -p%password% --host=%host% --port=%port% <GardenNotebook_MySQL_3_0_0.sql >install_log_create.txt

if /i "%doload%"=="N" (goto myexit)

mysql -u%user% -p%password% --host=%host% --port=%port% <DB_inserts_MySQL.sql >install_log_system.txt

mysql -u%user% -p%password% --host=%host% --port=%port% <DB_inserts_MySQL_local.sql >install_log_user.txt

goto myexit

:sqlserver
echo initialising SQLSserver database

sqlcmd -U %user% -P %password% -S %host%,%port% -i GardenNotebook_SQLServer_3_0_0.sql >install_log_create.txt

if /i "%doload%"=="N" (goto myexit)

sqlcmd -U %user% -P %password% -S %host%,%port% -i DB_inserts_SQLServer.sql >install_log_system.txt

sqlcmd -U %user% -P %password% -S %host%,%port% -i DB_inserts_SQLServer_local.sql >install_log_user.txt

goto myexit

:help
echo Build the Garden Notebook database and populate with basic data
echo DB_Builder [/?] [/D RDBMS] [/u username] [/w password] [/h hostname] [/p portnumber] [/n]
echo - /? show this help and exit
echo - /D the database manager (RDBMS) to use.  One of MySQL, MariaDB, SQLServer.  Default is MySQL.
echo - /u the username to use (default is root).  User must have SUPER privilege.  NB the default value is not appropriate for SQLServer.
echo - /w the password to use (required).
echo - /h the host for the RDBMS (default is localhost, i.e. this PC).
echo - /p the port number for the host (default is 3306, the default for MySQL; MariaDB uses 3307; SQLServer uses 1433).
echo - /n do NOT insert basic data.  Use this if restoring, e.g. from a JSON dump after updating the application.


:myexit
rem set port=
rem set host=
rem set user=
rem set password=
rem set doload=

endlocal